/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.utils.EMFStringValueConverter;
import org.eclipse.papyrus.infra.tools.converter.ConvertedValueContainer;
import org.eclipse.papyrus.infra.tools.converter.MultiConvertedValueContainer;
import org.eclipse.papyrus.infra.tools.converter.StringValueConverterStatus;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.papyrus.uml.tools.utils.messages.Messages;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLStringValueConverter
extends EMFStringValueConverter {
    protected final Map<EClass, NameResolutionHelper> nameResolutionHelpers = new HashMap<EClass, NameResolutionHelper>();
    public static final String THE_ENUMERATION_LITERAL_X_CANT_BE_FOUND = Messages.UMLStringValueConverter_TheEnumerationLiteralXCantBeFound;

    public UMLStringValueConverter(EObject context, String multiValueSeparator) {
        super(context, multiValueSeparator);
    }

    public void dispose() {
        super.dispose();
        this.nameResolutionHelpers.clear();
    }

    protected int getFeatureUpperBound(Object feature) {
        if (feature instanceof Property) {
            return ((Property)feature).getUpper();
        }
        return super.getFeatureUpperBound(feature);
    }

    protected EClassifier getFeatureType(Object feature) {
        PrimitiveType pType;
        String name;
        Type type;
        Object featureType = feature instanceof Property ? ((type = ((Property)feature).getType()) instanceof PrimitiveType ? ("Boolean".equals(name = (pType = (PrimitiveType)type).getName()) ? EcorePackage.eINSTANCE.getEBoolean() : ("Integer".equals(name) ? EcorePackage.eINSTANCE.getEInt() : ("Real".equals(name) ? EcorePackage.eINSTANCE.getEDouble() : ("String".equals(name) ? EcorePackage.eINSTANCE.getEString() : ("UnlimitedNatural".equals(name) ? EcorePackage.eINSTANCE.getEInt() : EcorePackage.eINSTANCE.getEString()))))) : (type instanceof Enumeration ? UMLPackage.eINSTANCE.getEnumeration() : (type instanceof DataType ? EcorePackage.eINSTANCE.getEString() : type.eClass()))) : super.getFeatureType(feature);
        return featureType;
    }

    protected ConvertedValueContainer<?> doDeduceValueFromString(Object feature, String valueAsString) {
        EClassifier featureType = this.getFeatureType(feature);
        if (feature instanceof Property) {
            return this.deduceValueFromString(feature, featureType, valueAsString);
        }
        return super.doDeduceValueFromString(feature, valueAsString);
    }

    protected ConvertedValueContainer<?> deduceValueFromString(Object feature, EClassifier featureType, String valueAsString) {
        if (featureType instanceof EClass && feature instanceof Property) {
            boolean isMany;
            int upperbound = this.getFeatureUpperBound(feature);
            boolean bl = isMany = upperbound > 1 || upperbound == -1;
            if ("Enumeration".equals(featureType.getName())) {
                return this.deduceEnumerationLiteralValue(isMany, valueAsString, (Enumeration)((Property)feature).getType());
            }
        }
        return super.deduceValueFromString(feature, featureType, valueAsString);
    }

    protected ConvertedValueContainer<?> deduceEObjectValue(EObject resolutionContext, Object feature, EClass eClass, boolean isMany, String valueAsString) {
        Object namespace = resolutionContext instanceof Namespace ? (Namespace)resolutionContext : (resolutionContext instanceof Element ? ((Element)resolutionContext).getNearestPackage() : null);
        if (valueAsString != null && valueAsString.length() != 0 && namespace != null) {
            IStatus iStatus = Status.OK_STATUS;
            ArrayList<String> unresolvedValues = new ArrayList<String>();
            ConvertedValueContainer returnedValue = null;
            NameResolutionHelper helper = this.nameResolutionHelpers.get(eClass);
            if (helper == null) {
                helper = new NameResolutionHelper((Namespace)namespace, eClass);
                this.nameResolutionHelpers.put(eClass, helper);
            }
            if (isMany) {
                HashSet<NamedElement> values = new HashSet<NamedElement>();
                String[] stringArray = valueAsString.split(this.multiValueSeparator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    List<NamedElement> elements = helper.getNamedElements(str);
                    if (elements.size() == 1) {
                        values.add(elements.get(0));
                    } else {
                        unresolvedValues.add(str);
                    }
                    if (!unresolvedValues.isEmpty()) {
                        iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.emf", NLS.bind((String)SOME_STRING_CANT_BE_RESOLVED_TO_FIND_X, (Object)eClass.getName()), unresolvedValues);
                    }
                    returnedValue = new MultiConvertedValueContainer(values, iStatus);
                    ++n2;
                }
            } else {
                List<NamedElement> elements = helper.getNamedElements(valueAsString);
                if (elements.size() == 1) {
                    returnedValue = new ConvertedValueContainer((Object)elements.get(0), iStatus);
                } else {
                    unresolvedValues.add(valueAsString);
                    iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.emf", NLS.bind((String)NO_X_REPRESENTED_BY_Y_HAVE_BEEN_FOUND, (Object)eClass.getName(), (Object)valueAsString), unresolvedValues);
                    returnedValue = new ConvertedValueContainer(null, iStatus);
                }
            }
            return returnedValue;
        }
        return super.deduceEObjectValue(resolutionContext, feature, eClass, isMany, valueAsString);
    }

    protected ConvertedValueContainer<?> deduceEnumerationLiteralValue(boolean isMany, String valueAsString, Enumeration enumeration) {
        ConvertedValueContainer returnedValue = null;
        IStatus iStatus = Status.OK_STATUS;
        ArrayList<String> unresolvedValues = new ArrayList<String>();
        if (isMany) {
            ArrayList<EnumerationLiteral> values = new ArrayList<EnumerationLiteral>();
            String[] stringArray = valueAsString.split(this.multiValueSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                EnumerationLiteral lit = (EnumerationLiteral)enumeration.getMember(str);
                if (lit != null) {
                    values.add(lit);
                } else {
                    unresolvedValues.add(str);
                }
                ++n2;
            }
            if (!unresolvedValues.isEmpty()) {
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.emf", NLS.bind((String)SOME_STRING_ARE_NOT_VALID_TO_CREATE_X, (Object)"EnumerationLiteral"), unresolvedValues);
            }
            returnedValue = new MultiConvertedValueContainer(values, iStatus);
        } else {
            EnumerationLiteral lit = (EnumerationLiteral)enumeration.getMember(valueAsString);
            if (lit == null) {
                unresolvedValues.add(valueAsString);
                iStatus = new StringValueConverterStatus(4, "org.eclipse.papyrus.infra.emf", NLS.bind((String)THE_ENUMERATION_LITERAL_X_CANT_BE_FOUND, (Object)valueAsString, (Object)"EnumerationLiteral"), unresolvedValues);
            }
            returnedValue = new ConvertedValueContainer((Object)lit, iStatus);
        }
        return returnedValue;
    }
}

