/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.operation.DelegatingUndoContext;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.views.modelexplorer.IPageBookViewPageListener;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.MultiViewPageBookView;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ViewPartPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

class ModelExplorerPropertySheetPage
extends TabbedPropertySheetPage
implements IPageBookViewPageListener {
    private final ModelExplorerPageBookView modelExplorer;
    private UndoActionHandler undo = null;
    private RedoActionHandler redo = null;
    private DelegatingUndoContext undoContext = null;

    public ModelExplorerPropertySheetPage(ModelExplorerPageBookView modelExplorer) {
        super((ITabbedPropertySheetPageContributor)modelExplorer);
        this.modelExplorer = modelExplorer;
        modelExplorer.addPageListener(this);
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        this.undoContext = new DelegatingUndoContext.Dynamic((Supplier)new Supplier<IUndoContext>(){

            public IUndoContext get() {
                return (IUndoContext)AdapterUtils.adapt((Object)((Object)ModelExplorerPropertySheetPage.this.modelExplorer), IUndoContext.class, null);
            }
        });
        this.undo = new UndoActionHandler(this.getSite().getPage().getActivePart().getSite(), (IUndoContext)this.undoContext);
        this.redo = new RedoActionHandler(this.getSite().getPage().getActivePart().getSite(), (IUndoContext)this.undoContext);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redo);
    }

    public void dispose() {
        this.modelExplorer.removePageListener(this);
        if (this.undo != null) {
            this.undo.dispose();
        }
        if (this.redo != null) {
            this.redo.dispose();
        }
        super.dispose();
    }

    public void pageActivated(MultiViewPageBookView pageBookView, ViewPartPage page) {
        this.selectionChanged((IWorkbenchPart)this.modelExplorer, pageBookView.getSite().getSelectionProvider().getSelection());
    }

    public void pageClosing(MultiViewPageBookView pageBookView, ViewPartPage page) {
        if (this.isSelectionUnloading((ServicesRegistry)page.getAdapter(ServicesRegistry.class))) {
            this.selectionChanged((IWorkbenchPart)this.modelExplorer, (ISelection)StructuredSelection.EMPTY);
        }
    }

    private boolean isSelectionUnloading(final ServicesRegistry context) {
        boolean result = false;
        ISelection currentSelection = this.getCurrentSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            result = Iterators.any((Iterator)selection.iterator(), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    try {
                        EObject eObject = EMFHelper.getEObject((Object)input);
                        return eObject != null && (eObject.eIsProxy() || ServiceUtilsForEObject.getInstance().getServiceRegistry(eObject) == context);
                    }
                    catch (ServiceException e) {
                        return false;
                    }
                }
            });
        }
        return result;
    }
}

