/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.provider;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.ui.IWorkbenchPart;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    public static final String IS_EOBJECT = "isEObject";
    public static final String IS_MODEL_EXPLORER = "isModelExplorer";
    public static final String IS_PAGE = "isPage";
    public static final String ECLASS = "eClass";
    private static final Pattern QNAME_SEPARATOR = Pattern.compile("\\.|::");

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_EOBJECT.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isObject((IStructuredSelection)receiver);
            return Boolean.valueOf(answer).equals(expectedValue);
        }
        if (IS_MODEL_EXPLORER.equals(property) && receiver instanceof IWorkbenchPart) {
            boolean answer = this.isModelExplorer((IWorkbenchPart)receiver);
            return Boolean.valueOf(answer).equals(expectedValue);
        }
        if (IS_PAGE.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isPage((IStructuredSelection)receiver);
            return Boolean.valueOf(answer).equals(expectedValue);
        }
        if (ECLASS.equals(property) && receiver instanceof IStructuredSelection && expectedValue instanceof String) {
            return this.hasEClass((IStructuredSelection)receiver, (String)expectedValue);
        }
        return false;
    }

    private boolean isPage(IStructuredSelection selection) {
        IPageManager pageManager = this.getPageManager(selection);
        if (pageManager != null && !selection.isEmpty()) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                EObject current = EMFHelper.getEObject(iter.next());
                if (this.isPage(current, pageManager)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isPage(EObject element, IPageManager pageManager) {
        if (element == null) {
            return false;
        }
        if (pageManager.allPages().contains(element)) {
            return true;
        }
        Object openable = Platform.getAdapterManager().getAdapter((Object)element, IOpenable.class);
        return openable instanceof IOpenable;
    }

    protected IPageManager getPageManager(IStructuredSelection selection) {
        IPageManager pageMngr = null;
        try {
            ServiceUtilsForSelection instance = ServiceUtilsForSelection.getInstance();
            if (instance != null) {
                pageMngr = instance.getIPageManager((Object)selection);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pageMngr;
    }

    private boolean isModelExplorer(IWorkbenchPart receiver) {
        return receiver instanceof ModelExplorerPageBookView;
    }

    private boolean isObject(IStructuredSelection selection) {
        Iterator iter;
        if (!selection.isEmpty() && (iter = selection.iterator()).hasNext()) {
            EObject current = EMFHelper.getEObject(iter.next());
            return current != null;
        }
        return false;
    }

    protected boolean hasEClass(IStructuredSelection selection, String eClassQName) {
        EClassifier eClassifier;
        if (!selection.isEmpty() && (eClassifier = this.resolveEClass(EMFHelper.getEObject((Object)selection.getFirstElement()), eClassQName)) != null) {
            boolean result = true;
            Iterator iter = selection.iterator();
            while (result && iter.hasNext()) {
                EObject next = EMFHelper.getEObject(iter.next());
                boolean bl = result = next != null && eClassifier.isInstance((Object)next);
            }
            return result;
        }
        return false;
    }

    protected EClassifier resolveEClass(Object context, String eClassQName) {
        EClassifier result = null;
        if (context instanceof EObject) {
            String basePackageName;
            EPackage basePackage;
            EClass contextClass = ((EObject)context).eClass();
            String[] segments = QNAME_SEPARATOR.split(eClassQName);
            if (segments.length > 1 && (basePackage = PropertyTester.resolvePackage(contextClass, basePackageName = segments[0])) != null) {
                EPackage ePackage = basePackage;
                int lastPackage = segments.length - 1;
                int i = 1;
                while (ePackage != null && i < lastPackage) {
                    ePackage = PropertyTester.getSubPackage(ePackage, segments[i]);
                    ++i;
                }
                if (ePackage != null) {
                    result = ePackage.getEClassifier(segments[segments.length - 1]);
                }
            }
        }
        return result;
    }

    static EPackage resolvePackage(EClass contextEClass, String name) {
        EPackage result = null;
        if (name.equals(contextEClass.getEPackage().getName())) {
            result = contextEClass.getEPackage();
        } else {
            for (EClass next : contextEClass.getEAllSuperTypes()) {
                if (!name.equals(next.getEPackage().getName())) continue;
                result = next.getEPackage();
                break;
            }
        }
        return result;
    }

    static EPackage getSubPackage(EPackage superPackage, String name) {
        EPackage result = null;
        for (EPackage next : superPackage.getESubpackages()) {
            if (!name.equals(next.getName())) continue;
            result = next;
            break;
        }
        return result;
    }
}

