/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.hyperlink;

import com.google.common.base.Objects;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.cdo.internal.ui.dialogs.CheckoutBrowseDialog;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CDOResourceHyperlink;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.Messages;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkDocumentShell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;

public class CDOResourceHyperlinkEditorShell
extends AbstractEditHyperlinkDocumentShell {
    private boolean usedefaultTooltip = true;
    private CDOResourceHyperlink hyperlink;
    private boolean okPressed;

    public CDOResourceHyperlink getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(CDOResourceHyperlink hyperlink) {
        this.hyperlink = hyperlink;
        this.getObjectLabeltext().setText(hyperlink.getHyperlink().toString());
        this.getTooltipInputText().setText(hyperlink.getTooltipText());
        this.usedefaultTooltip = Objects.equal((Object)this.getObjectLabeltext().getText(), (Object)this.getTooltipInputText().getText());
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getTooltipInputText().setEditable(!this.usedefaultTooltip);
    }

    public boolean open() {
        Display display = Display.getCurrent();
        this.okPressed = false;
        this.getEditHyperlinkShell().pack();
        this.getEditHyperlinkShell().open();
        while (!this.getEditHyperlinkShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.okPressed;
    }

    public CDOResourceHyperlinkEditorShell() {
        this.createEditHyperlinkShell();
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getObjectLabeltext().setEditable(false);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabeltext().getText());
        }
        this.getUseDefaultCheckBox().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CDOResourceHyperlinkEditorShell.this.usedefaultTooltip = CDOResourceHyperlinkEditorShell.this.getUseDefaultCheckBox().getSelection();
                if (CDOResourceHyperlinkEditorShell.this.usedefaultTooltip) {
                    CDOResourceHyperlinkEditorShell.this.getTooltipInputText().setEditable(false);
                    CDOResourceHyperlinkEditorShell.this.getTooltipInputText().setText(CDOResourceHyperlinkEditorShell.this.getObjectLabeltext().getText());
                } else {
                    CDOResourceHyperlinkEditorShell.this.getTooltipInputText().setEditable(true);
                }
            }
        });
        this.getChooseDiagramButton().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CheckoutBrowseDialog browse = new CheckoutBrowseDialog(CDOResourceHyperlinkEditorShell.this.getEditHyperlinkShell(), Messages.CDOResourceHyperlinkEditorShell_title, Messages.CDOResourceHyperlinkEditorShell_message, null, 4096);
                browse.setBlockOnOpen(true);
                String initialURIString = CDOResourceHyperlinkEditorShell.this.getObjectLabeltext().getText().trim();
                if (!initialURIString.isEmpty()) {
                    browse.setInitialURI(URI.createURI((String)initialURIString));
                }
                browse.setNodeTypeFilter(EresourcePackage.Literals.CDO_RESOURCE_LEAF);
                if (browse.open() == 0) {
                    URI selected = browse.getSelectedURI();
                    if (selected != null) {
                        CDOResourceHyperlinkEditorShell.this.getObjectLabeltext().setText(selected.toString());
                    }
                    if (CDOResourceHyperlinkEditorShell.this.usedefaultTooltip) {
                        CDOResourceHyperlinkEditorShell.this.getTooltipInputText().setText(selected.toString());
                    }
                }
            }
        });
        this.getCancelButton().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CDOResourceHyperlinkEditorShell.this.hyperlink = null;
                CDOResourceHyperlinkEditorShell.this.getEditHyperlinkShell().close();
            }
        });
        this.getOkButton().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (CDOResourceHyperlinkEditorShell.this.hyperlink == null) {
                    CDOResourceHyperlinkEditorShell.this.hyperlink = new CDOResourceHyperlink();
                }
                CDOResourceHyperlinkEditorShell.this.hyperlink.setHyperlink(URI.createURI((String)CDOResourceHyperlinkEditorShell.this.getObjectLabeltext().getText().trim()));
                CDOResourceHyperlinkEditorShell.this.hyperlink.setTooltipText(CDOResourceHyperlinkEditorShell.this.getTooltipInputText().getText().trim());
                CDOResourceHyperlinkEditorShell.this.okPressed = true;
                CDOResourceHyperlinkEditorShell.this.getEditHyperlinkShell().close();
            }
        });
    }
}

