/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.codegen.base;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.codegen.base.ILocationStrategy;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public abstract class ModelElementsCreator {
    protected ILocationStrategy locStrategy;
    protected IPFileSystemAccess fileSystemAccess;

    public ModelElementsCreator(IPFileSystemAccess fileSystemAccess, ILocationStrategy locStrategy) {
        this.fileSystemAccess = fileSystemAccess;
        this.locStrategy = locStrategy;
    }

    public String getFileName(NamedElement element) {
        return this.locStrategy.getFileName(element);
    }

    protected abstract void createPackageableElementFile(PackageableElement var1, IProgressMonitor var2);

    protected abstract boolean noCodeGen(Element var1);

    public void createPackageableElement(PackageableElement element, IProgressMonitor monitor) {
        this.createPackageableElement(element, monitor, true);
    }

    public void createPackageableElement(PackageableElement element, IProgressMonitor monitor, boolean recursive) {
        if (this.noCodeGen((Element)element)) {
            return;
        }
        if (element instanceof Package) {
            Package pkg = (Package)element;
            if (monitor != null) {
                monitor.subTask("generate package " + element.getQualifiedName());
            }
            this.createPackageableElementFile(element, monitor);
            if (recursive) {
                for (PackageableElement subElement : pkg.getPackagedElements()) {
                    this.createPackageableElement(subElement, monitor, recursive);
                }
            }
        } else {
            this.createPackageableElementFile(element, monitor);
        }
    }

    public void removePackageableElement(PackageableElement element, IProgressMonitor monitor) {
        String fileName = this.getFileName((NamedElement)element);
        this.fileSystemAccess.deleteFile(fileName);
    }
}

