/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dc.impl;

import java.awt.Color;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.dd.dc.Bounds;
import org.eclipse.papyrus.dd.dc.DCFactory;
import org.eclipse.papyrus.dd.dc.DCPackage;
import org.eclipse.papyrus.dd.dc.Dimension;
import org.eclipse.papyrus.dd.dc.KnownColor;
import org.eclipse.papyrus.dd.dc.Point;
import org.eclipse.papyrus.dd.dc.impl.BoundsImpl;
import org.eclipse.papyrus.dd.dc.impl.DimensionImpl;
import org.eclipse.papyrus.dd.dc.impl.PointImpl;

public class DCFactoryImpl
extends EFactoryImpl
implements DCFactory {
    public static DCFactory init() {
        try {
            DCFactory theDCFactory = (DCFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.omg.org/spec/DD/20110901/DC");
            if (theDCFactory != null) {
                return theDCFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DCFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createPoint();
            }
            case 1: {
                return this.createDimension();
            }
            case 2: {
                return this.createBounds();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createKnownColorFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createBooleanFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createIntegerFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createRealFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createStringFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createColorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertKnownColorToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertBooleanToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertIntegerToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertRealToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertStringToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertColorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Point createPoint() {
        PointImpl point = new PointImpl();
        return point;
    }

    @Override
    public Dimension createDimension() {
        DimensionImpl dimension = new DimensionImpl();
        return dimension;
    }

    @Override
    public Bounds createBounds() {
        BoundsImpl bounds = new BoundsImpl();
        return bounds;
    }

    public KnownColor createKnownColorFromString(EDataType eDataType, String initialValue) {
        KnownColor result = KnownColor.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertKnownColorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Boolean createBooleanFromString(EDataType eDataType, String initialValue) {
        return (Boolean)super.createFromString(eDataType, initialValue);
    }

    public String convertBooleanToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Integer createIntegerFromString(EDataType eDataType, String initialValue) {
        return (Integer)super.createFromString(eDataType, initialValue);
    }

    public String convertIntegerToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Double createRealFromString(EDataType eDataType, String initialValue) {
        return (Double)super.createFromString(eDataType, initialValue);
    }

    public String convertRealToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String createStringFromString(EDataType eDataType, String initialValue) {
        return (String)super.createFromString(eDataType, initialValue);
    }

    public String convertStringToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Color createColorFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null || initialValue.isEmpty()) {
            return null;
        }
        return Color.decode(initialValue);
    }

    public String convertColorToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        Color c = (Color)instanceValue;
        return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public DCPackage getDCPackage() {
        return (DCPackage)this.getEPackage();
    }

    @Deprecated
    public static DCPackage getPackage() {
        return DCPackage.eINSTANCE;
    }
}

