/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dc.util;

import java.awt.Color;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.dd.dc.Bounds;
import org.eclipse.papyrus.dd.dc.DCPackage;
import org.eclipse.papyrus.dd.dc.Dimension;
import org.eclipse.papyrus.dd.dc.KnownColor;
import org.eclipse.papyrus.dd.dc.Point;

public class DCValidator
extends EObjectValidator {
    public static final DCValidator INSTANCE = new DCValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.dd.dc";
    public static final int DIMENSION__NON_NEGATIVE_WIDTH = 1;
    public static final int DIMENSION__NON_NEGATIVE_HEIGHT = 2;
    public static final int BOUNDS__NON_NEGATIVE_WIDTH = 3;
    public static final int BOUNDS__NON_NEGATIVE_HEIGHT = 4;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 4;
    protected static final int DIAGNOSTIC_CODE_COUNT = 4;

    public static boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String validationDelegate, EOperation invariant, String expression, int severity, String source, int code) {
        return EObjectValidator.validate((EClass)eClass, (EObject)eObject, (DiagnosticChain)diagnostics, context, (String)validationDelegate, (EOperation)invariant, (String)expression, (int)severity, (String)source, (int)code);
    }

    protected EPackage getEPackage() {
        return DCPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePoint((Point)value, diagnostics, context);
            }
            case 1: {
                return this.validateDimension((Dimension)value, diagnostics, context);
            }
            case 2: {
                return this.validateBounds((Bounds)value, diagnostics, context);
            }
            case 3: {
                return this.validateKnownColor((KnownColor)((Object)value), diagnostics, context);
            }
            case 4: {
                return this.validateBoolean((Boolean)value, diagnostics, context);
            }
            case 5: {
                return this.validateInteger((Integer)value, diagnostics, context);
            }
            case 6: {
                return this.validateReal((Double)value, diagnostics, context);
            }
            case 7: {
                return this.validateString((String)value, diagnostics, context);
            }
            case 8: {
                return this.validateColor((Color)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePoint(Point point, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(point, diagnostics, context);
    }

    public boolean validateDimension(Dimension dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dimension, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dimension, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimension_nonNegativeWidth(dimension, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDimension_nonNegativeHeight(dimension, diagnostics, context);
        }
        return result;
    }

    public boolean validateDimension_nonNegativeWidth(Dimension dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return dimension.nonNegativeWidth(diagnostics, context);
    }

    public boolean validateDimension_nonNegativeHeight(Dimension dimension, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return dimension.nonNegativeHeight(diagnostics, context);
    }

    public boolean validateBounds(Bounds bounds, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(bounds, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(bounds, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBounds_nonNegativeWidth(bounds, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBounds_nonNegativeHeight(bounds, diagnostics, context);
        }
        return result;
    }

    public boolean validateBounds_nonNegativeWidth(Bounds bounds, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return bounds.nonNegativeWidth(diagnostics, context);
    }

    public boolean validateBounds_nonNegativeHeight(Bounds bounds, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return bounds.nonNegativeHeight(diagnostics, context);
    }

    public boolean validateKnownColor(KnownColor knownColor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBoolean(boolean boolean_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateInteger(int integer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateReal(double real, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateString(String string, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateColor(Color color, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

