/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dd.dg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TextAnchor implements Enumerator
{
    START(0, "start", "start"),
    MIDDLE(1, "middle", "middle"),
    END(2, "end", "end");

    public static final int START_VALUE = 0;
    public static final int MIDDLE_VALUE = 1;
    public static final int END_VALUE = 2;
    private static final TextAnchor[] VALUES_ARRAY;
    public static final List<TextAnchor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TextAnchor[]{START, MIDDLE, END};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TextAnchor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextAnchor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextAnchor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextAnchor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextAnchor get(int value) {
        switch (value) {
            case 0: {
                return START;
            }
            case 1: {
                return MIDDLE;
            }
            case 2: {
                return END;
            }
        }
        return null;
    }

    private TextAnchor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

