/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Sara TUCCI (CEA LIST) sara.tucci@cea.fr - Initial API and implementation
 *  Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *  David SERVAT (CEA LIST) david.servat@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.eastadl.structure.functionmodeling.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrus.eastadl.structure.functionmodeling.AnalysisFunctionPrototype;
import org.eclipse.papyrus.eastadl.structure.functionmodeling.AnalysisFunctionType;
import org.eclipse.papyrus.eastadl.structure.functionmodeling.FunctionType;
import org.eclipse.papyrus.eastadl.structure.functionmodeling.FunctionmodelingPackage;
import org.eclipse.papyrus.eastadl.utils.EASTResource;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;


/**
 * <!-- begin-user-doc --> An implementation of the model object ' <em><b>Analysis Function Prototype</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.eastadl.structure.functionmodeling.impl.AnalysisFunctionPrototypeImpl#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AnalysisFunctionPrototypeImpl extends FunctionPrototypeImpl implements AnalysisFunctionPrototype {

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected AnalysisFunctionPrototypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public AnalysisFunctionType basicGetType() {

		AnalysisFunctionType type = null;

		if (getBase_Property() != null) {
			// Retrieve the type of the ADLFunctionPrototype
			Type basicType = getBase_Property().getType();


			if (basicType != null) {
				type = UMLUtil.getStereotypeApplication(basicType, AnalysisFunctionType.class);
			}
		}

		return type;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FunctionmodelingPackage.ANALYSIS_FUNCTION_PROTOTYPE__TYPE:
			if (resolve) {
				return getType();
			}
			return basicGetType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FunctionmodelingPackage.ANALYSIS_FUNCTION_PROTOTYPE__TYPE:
			return basicGetType() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return FunctionmodelingPackage.Literals.ANALYSIS_FUNCTION_PROTOTYPE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public Image getIcon() {

		Image ImageNotFound = null;

		if (getBase_Property() != null) {
			Stereotype st = getBase_Property().getAppliedStereotype(EASTResource.ANALYSISFUNCTIONPROTOTYPE_ID);

			Image defaultImage = st.getIcons().get(0);
			Image typeImage = null;

			FunctionType type = getType();
			if ((type != null) && (type.getBase_Class() != null)) {
				typeImage = ElementUtil.getStereotypeImage(type.getBase_Class(), "icon");
			}

			if (typeImage != null) {
				return typeImage;
			} else {
				return defaultImage;
			}

		} else {
			return ImageNotFound;
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public AnalysisFunctionType getType() {
		AnalysisFunctionType type = basicGetType();
		return type != null && type.eIsProxy() ? (AnalysisFunctionType) eResolveProxy((InternalEObject) type) : type;
	}

} // AnalysisFunctionPrototypeImpl
