/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.FCM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContainerRuleKind implements Enumerator
{
    COMPONENT_RULE(0, "ComponentRule", "ComponentRule"),
    LIGHT_WEIGHT_OO_RULE(1, "LightWeightOORule", "LightWeightOORule");

    public static final int COMPONENT_RULE_VALUE = 0;
    public static final int LIGHT_WEIGHT_OO_RULE_VALUE = 1;
    private static final ContainerRuleKind[] VALUES_ARRAY;
    public static final List<ContainerRuleKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainerRuleKind[]{COMPONENT_RULE, LIGHT_WEIGHT_OO_RULE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainerRuleKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerRuleKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerRuleKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerRuleKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerRuleKind get(int value) {
        switch (value) {
            case 0: {
                return COMPONENT_RULE;
            }
            case 1: {
                return LIGHT_WEIGHT_OO_RULE;
            }
        }
        return null;
    }

    private ContainerRuleKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

