/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints;

import java.util.MissingResourceException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class MarkerUtils {
    public static ResourceSet resourceSet = new ResourceSetImpl();

    public static URI getURI(IMarker marker) {
        String uriOfMarkerStr = marker.getAttribute("uri", null);
        if (uriOfMarkerStr != null) {
            return URI.createURI((String)uriOfMarkerStr);
        }
        return null;
    }

    public static EObject getEObjectOfMarker(IMarker marker) {
        return MarkerUtils.getEObjectOfMarker(resourceSet, marker);
    }

    public static EObject getEObjectOfMarker(ResourceSet pResourceSet, IMarker marker) {
        URI uriOfMarker = MarkerUtils.getURI(marker);
        if (uriOfMarker != null) {
            try {
                pResourceSet.getResource(uriOfMarker.trimFragment(), true);
                return pResourceSet.getEObject(uriOfMarker, true);
            }
            catch (MissingResourceException e) {
                throw new RuntimeException("MarkerUtils.getEObjectOfMarker: " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean isActive(IMarker marker) {
        return marker.getAttribute("isActive", false);
    }
}

