/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.services.tracepoints.Activator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.State;

public class TraceActions {
    public static String[][] getStringFields(Enum<?>[] enumValues) {
        int i = 0;
        String[][] taOptions = new String[enumValues.length][2];
        Enum<?>[] enumArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> tLiteral = enumArray[n2];
            taOptions[i][1] = tLiteral.name();
            taOptions[i][0] = tLiteral.name();
            ++i;
            ++n2;
        }
        return taOptions;
    }

    public static String getOptions(String traceAction, TraceFeature subFeature) {
        String prefix = TraceActions.getStringPrefix(subFeature);
        int pos = traceAction.indexOf(prefix);
        if (pos == -1) {
            return null;
        }
        int endPos = traceAction.indexOf(44, pos += prefix.length());
        if (endPos == -1) {
            return traceAction.substring(pos);
        }
        return traceAction.substring(pos, endPos);
    }

    public static String getStringPrefix(TraceFeature feature) {
        if (feature == TraceFeature.Class) {
            return "C:";
        }
        if (feature == TraceFeature.Port) {
            return "P:";
        }
        if (feature == TraceFeature.State) {
            return "S:";
        }
        if (feature == TraceFeature.Operation) {
            return "O:";
        }
        return null;
    }

    public static String actionFromPreferences(TraceFeature feature) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (feature == TraceFeature.Class) {
            return TraceActions.compositeClassOption(store.getInt("papyrus.trace.option.class"), store.getInt("papyrus.trace.option.state"), store.getInt("papyrus.trace.option.op"));
        }
        if (feature == TraceFeature.State) {
            return store.getString("papyrus.trace.option.state");
        }
        if (feature == TraceFeature.Operation) {
            return store.getString("papyrus.trace.option.op");
        }
        return "";
    }

    public static String compositeClassOption(int classOption, int stateOption, int operationOption) {
        return String.valueOf(TraceActions.getStringPrefix(TraceFeature.Class)) + classOption + "," + TraceActions.getStringPrefix(TraceFeature.State) + stateOption + "," + TraceActions.getStringPrefix(TraceFeature.Operation) + operationOption;
    }

    public static String actionFromPreferences(EObject element) {
        return TraceActions.actionFromPreferences(TraceActions.getTraceFeature(element));
    }

    public static TraceFeature getTraceFeature(EObject element) {
        if (element instanceof State) {
            return TraceFeature.State;
        }
        if (element instanceof Operation) {
            return TraceFeature.Operation;
        }
        if (element instanceof Class) {
            return TraceFeature.Class;
        }
        return null;
    }

    public static enum TAActivity {
        activity;

    }

    public static enum TAAttribute {
        PropertyRead,
        PropertyWrite;

    }

    public static enum TAClass {
        Creation,
        Destruction,
        AllOperations,
        AllPorts,
        AllStates;

    }

    public static enum TAOperation {
        OnlyCall,
        ParameterValues;

    }

    public static enum TAState {
        StateEnter,
        StateLeave,
        Transition;

    }

    public static enum TraceFeature {
        Class,
        Port,
        State,
        Operation;

    }

    public static enum TraceScope {
        clazz,
        operation,
        state,
        activity;

    }
}

