/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.tracepoints.dialogs;

import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.services.tracepoints.ITraceMechanism;
import org.eclipse.papyrus.infra.services.tracepoints.Messages;
import org.eclipse.papyrus.infra.services.tracepoints.TraceActions;
import org.eclipse.papyrus.infra.services.tracepoints.TraceMechanism;
import org.eclipse.papyrus.infra.services.tracepoints.preferences.BinaryEncodedMChoiceFieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.State;

public class TraceActionSelection
extends SelectionStatusDialog {
    protected CheckboxTableViewer fTraceImplementations;
    protected Text fDescription;
    IMarker m_marker;
    BinaryEncodedMChoiceFieldEditor classOptions;
    BinaryEncodedMChoiceFieldEditor operationOptions;
    BinaryEncodedMChoiceFieldEditor stateOptions;
    private Element m_me;

    public TraceActionSelection(Shell parent, IMarker marker, Element me) {
        super(parent);
        this.m_me = me;
        this.m_marker = marker;
    }

    protected void computeResult() {
        String traceActionValue = null;
        if (this.m_me instanceof State) {
            traceActionValue = this.stateOptions.getResult();
        } else if (this.m_me instanceof Class) {
            traceActionValue = TraceActions.compositeClassOption(this.classOptions.getIntResult(), this.stateOptions.getIntResult(), this.operationOptions.getIntResult());
        } else if (this.m_me instanceof State) {
            traceActionValue = this.stateOptions.getResult();
        } else if (this.m_me instanceof Operation) {
            traceActionValue = this.operationOptions.getResult();
        }
        String traceMechanism = "";
        Object[] objectArray = this.fTraceImplementations.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableElement = objectArray[n2];
            traceMechanism = (String)tableElement;
            ++n2;
        }
        Object[] result = new Object[]{traceActionValue, traceMechanism};
        this.setResult(Arrays.asList(result));
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Label label = new Label(contents, 0);
        label.setText(Messages.TraceActionSelection_SelectTraceAction);
        String[][] taClassOptions = TraceActions.getStringFields(TraceActions.TAClass.values());
        String[][] taStateOptions = TraceActions.getStringFields(TraceActions.TAState.values());
        String[][] taOperationOptions = TraceActions.getStringFields(TraceActions.TAOperation.values());
        String actionString = this.m_marker.getAttribute("traceAction", "");
        String mechanismID = this.m_marker.getAttribute("traceMechanism", "");
        if (this.m_me instanceof State) {
            this.stateOptions = new BinaryEncodedMChoiceFieldEditor(Messages.TraceActionSelection_StateOptions, 3, taStateOptions, contents, true);
            this.stateOptions.setupViaString(actionString);
        } else if (this.m_me instanceof Class) {
            this.classOptions = new BinaryEncodedMChoiceFieldEditor(Messages.TraceActionSelection_ClassOptions, 3, taClassOptions, contents, true);
            this.stateOptions = new BinaryEncodedMChoiceFieldEditor(Messages.TraceActionSelection_StateOptions, 3, taStateOptions, contents, true);
            this.operationOptions = new BinaryEncodedMChoiceFieldEditor(Messages.TraceActionSelection_OperationOptions, 3, taOperationOptions, contents, true);
            this.classOptions.setupViaString(TraceActions.getOptions(actionString, TraceActions.TraceFeature.Class));
            this.stateOptions.setupViaString(TraceActions.getOptions(actionString, TraceActions.TraceFeature.State));
            this.operationOptions.setupViaString(TraceActions.getOptions(actionString, TraceActions.TraceFeature.Operation));
        } else if (this.m_me instanceof Operation) {
            this.operationOptions = new BinaryEncodedMChoiceFieldEditor(Messages.TraceActionSelection_OperationOptions, 3, taOperationOptions, contents, true);
            this.operationOptions.setupViaString(actionString);
        }
        Group implementationGroup = new Group(parent, 0);
        implementationGroup.setText(Messages.TraceActionSelection_ImplementationOptions);
        this.fTraceImplementations = CheckboxTableViewer.newCheckList((Composite)implementationGroup, (int)768);
        this.fTraceImplementations.setContentProvider((IContentProvider)new TraceMechanismsCP());
        this.fTraceImplementations.setInput((Object)this);
        this.fTraceImplementations.setChecked((Object)mechanismID, true);
        this.fTraceImplementations.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean isChecked = event.getChecked();
                if (isChecked) {
                    Object[] objectArray = TraceActionSelection.this.fTraceImplementations.getCheckedElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object checkedElement = objectArray[n2];
                        if (checkedElement != element) {
                            TraceActionSelection.this.fTraceImplementations.setChecked(checkedElement, false);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.fTraceImplementations.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object first;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
                    EList<ITraceMechanism> mechanisms = TraceMechanism.getTraceMechanisms();
                    boolean noDesc = true;
                    for (ITraceMechanism mechanism : mechanisms) {
                        String description = mechanism.getTraceMechanismDescription((EObject)TraceActionSelection.this.m_me, (String)first);
                        if (description == null) continue;
                        TraceActionSelection.this.fDescription.setText(description);
                        noDesc = false;
                        break;
                    }
                    if (noDesc) {
                        TraceActionSelection.this.fDescription.setText(Messages.TraceActionSelection_NotAvail);
                    }
                }
            }
        });
        this.fDescription = new Text((Composite)implementationGroup, 584);
        GridData span = new GridData();
        span.horizontalAlignment = 4;
        span.grabExcessHorizontalSpace = true;
        span.grabExcessVerticalSpace = true;
        span.verticalAlignment = 4;
        span.heightHint = 250;
        implementationGroup.setLayout((Layout)new GridLayout());
        implementationGroup.setLayoutData((Object)span);
        GridData span2 = new GridData();
        span2.horizontalAlignment = 4;
        span2.grabExcessHorizontalSpace = true;
        span2.grabExcessVerticalSpace = true;
        span2.verticalAlignment = 4;
        span2.heightHint = 80;
        this.fDescription.setLayoutData((Object)span2);
        this.fTraceImplementations.getTable().setLayoutData((Object)span2);
        parent.setLayout((Layout)new GridLayout(1, false));
        return contents;
    }

    protected void setTextFromData(TreeItem ti) {
        Object data = ti.getData();
        boolean cfr_ignored_0 = data instanceof InstanceSpecification;
    }

    protected void refreshTree(TreeItem ti) {
        this.setTextFromData(ti);
        TreeItem[] treeItemArray = ti.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            this.refreshTree(subItem);
            ++n2;
        }
    }

    class EnumLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EnumLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Enum) {
                return ((Enum)obj).name();
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class TraceMechanismsCP
    implements IStructuredContentProvider {
        TraceMechanismsCP() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] items = null;
            EList<ITraceMechanism> mechanisms = TraceMechanism.getTraceMechanisms();
            if (mechanisms.size() == 0) {
                items = new String[]{Messages.TraceActionSelection_NoPluginsProvideTraceExt};
            } else {
                BasicEList idList = new BasicEList();
                for (ITraceMechanism mechanism : mechanisms) {
                    for (String id : mechanism.getTraceMechanismIDs((EObject)TraceActionSelection.this.m_me)) {
                        idList.add((Object)id);
                    }
                }
                items = idList.toArray((Object[])new String[0]);
            }
            return items;
        }
    }
}

