/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.m2m.qvto;

import java.util.LinkedList;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;

public class NotationTypes {
    @Operation(contextual=true, kind=Operation.Kind.HELPER)
    public static void copyBendpoints(RelativeBendpoints source, RelativeBendpoints target, boolean convertToPixels) {
        LinkedList<RelativeBendpoint> result = new LinkedList<RelativeBendpoint>();
        for (Object point : source.getPoints()) {
            if (!(point instanceof RelativeBendpoint)) continue;
            RelativeBendpoint pointCopy = new RelativeBendpoint(((RelativeBendpoint)point).convertToString());
            result.add(pointCopy);
        }
        if (convertToPixels) {
            LinkedList<RelativeBendpoint> convertedResult = new LinkedList<RelativeBendpoint>();
            for (RelativeBendpoint point : result) {
                convertedResult.add(NotationTypes.convertToPixels(point));
            }
            result = convertedResult;
        }
        target.setPoints(result);
    }

    private static RelativeBendpoint convertToPixels(RelativeBendpoint bendpoint) {
        int newSourceX = NotationTypes.convertToPixels(bendpoint.getSourceX());
        int newSourceY = NotationTypes.convertToPixels(bendpoint.getSourceY());
        int newTargetX = NotationTypes.convertToPixels(bendpoint.getTargetX());
        int newTargetY = NotationTypes.convertToPixels(bendpoint.getTargetY());
        return new RelativeBendpoint(newSourceX, newSourceY, newTargetX, newTargetY);
    }

    private static int convertToPixels(int source) {
        return source / 25;
    }
}

