/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.PapyrusMarkerAdapter;
import org.eclipse.papyrus.moka.MokaConstants;
import org.eclipse.papyrus.moka.debug.MokaBreakpoint;
import org.eclipse.papyrus.moka.launch.EditorUtils;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationUtils {
    protected static AnimationUtils eInstance = null;
    protected static Map<EObject, IPapyrusMarker> eObjectToSuspendedMarker = new ConcurrentHashMap<EObject, IPapyrusMarker>();
    protected static Map<EObject, IPapyrusMarker> eObjectToAnimationMarker = new ConcurrentHashMap<EObject, IPapyrusMarker>();
    protected static Map<EObject, List<Diagram>> eObjectToDiagrams = new ConcurrentHashMap<EObject, List<Diagram>>();

    private AnimationUtils() {
    }

    public static void init() {
        eObjectToAnimationMarker = new ConcurrentHashMap<EObject, IPapyrusMarker>();
        eObjectToSuspendedMarker = new ConcurrentHashMap<EObject, IPapyrusMarker>();
        eObjectToDiagrams = new ConcurrentHashMap<EObject, List<Diagram>>();
    }

    public static void init(EObject eobject) {
        AnimationUtils.init();
        AnimationUtils.getInstance().getDiagrams(eobject);
    }

    public synchronized void removeAllAnimationMarker() {
        for (EObject animatedObject : eObjectToAnimationMarker.keySet()) {
            this.removeAnimationMarker(animatedObject);
        }
    }

    public static AnimationUtils getInstance() {
        if (eInstance == null) {
            eInstance = new AnimationUtils();
        }
        return eInstance;
    }

    public synchronized List<Diagram> getDiagrams(EObject modelElement) {
        List<Diagram> matchingDiagrams = eObjectToDiagrams.get(modelElement);
        if (matchingDiagrams != null) {
            return matchingDiagrams;
        }
        Resource resource = modelElement.eResource();
        if (!resource.getURI().isPlatformResource()) {
            matchingDiagrams = new ArrayList<Diagram>();
            eObjectToDiagrams.put(modelElement, new ArrayList());
            return matchingDiagrams;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        String resourceNotationURI = modelElement.eResource().getURI().toString().replaceAll("\\.uml$", ".notation");
        Resource notationResource = resourceSet.getResource(URI.createURI((String)resourceNotationURI), true);
        ArrayList<EObject> matchingObjects = new ArrayList<EObject>();
        matchingObjects.add(modelElement);
        Map maps = EcoreUtil.UsageCrossReferencer.findAll(matchingObjects, (ResourceSet)resourceSet);
        matchingDiagrams = new ArrayList<Diagram>();
        for (Object key : maps.keySet()) {
            for (EStructuralFeature.Setting setting : (Collection)maps.get(key)) {
                if (!(setting.getEObject() instanceof View)) continue;
                Diagram diagram = ((View)setting.getEObject()).getDiagram();
                if (!matchingDiagrams.contains(diagram)) {
                    matchingDiagrams.add(diagram);
                }
                TreeIterator i = diagram.eAllContents();
                while (i.hasNext()) {
                    EObject element;
                    EObject cddView = (EObject)i.next();
                    if (!(cddView instanceof View) || (element = ((View)cddView).getElement()) == modelElement || element == null) continue;
                    List<Diagram> diags = eObjectToDiagrams.get(element);
                    if (diags == null) {
                        diags = new ArrayList<Diagram>();
                    } else if (!diags.contains(diagram)) {
                        diags.add(diagram);
                    }
                    eObjectToDiagrams.put(element, diags);
                }
            }
        }
        eObjectToDiagrams.put(modelElement, matchingDiagrams);
        return matchingDiagrams;
    }

    public boolean diagramsExistFor(EObject modelElement) {
        return !this.getDiagrams(modelElement).isEmpty();
    }

    public void resetDiagrams(EObject modelElement) {
        eObjectToDiagrams.remove(modelElement);
    }

    public void openDiagram(Diagram diagram, boolean closeOpenedDiagrams) {
        block5: {
            IEditorPart part = EditorUtils.getEditorPart((EObject)diagram);
            ServicesRegistry servicesRegistry = (ServicesRegistry)part.getAdapter(ServicesRegistry.class);
            try {
                IPageManager pageMngr = ServiceUtils.getInstance().getIPageManager((Object)servicesRegistry);
                try {
                    if (pageMngr.isOpen((Object)diagram)) {
                        pageMngr.selectPage((Object)diagram);
                        break block5;
                    }
                    TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)diagram);
                    OpenDiagramCommand updateCommand = new OpenDiagramCommand(diagram, pageMngr, domain);
                    domain.getCommandStack().execute((Command)updateCommand);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            catch (ServiceException e1) {
                Activator.log.error((Throwable)e1);
            }
        }
    }

    public RootEditPart getRootEditPart(GraphicalEditor editor) {
        return (RootEditPart)editor.getAdapter(EditPart.class);
    }

    public void addSuspendedMarker(EObject semanticElement) {
        if (eObjectToSuspendedMarker.get(semanticElement) != null) {
            return;
        }
        if (semanticElement.eIsProxy()) {
            semanticElement = AnimationUtils.resolve(semanticElement);
        }
        IResource iresource = MokaBreakpoint.getIResource((Resource)semanticElement.eResource());
        try {
            if (iresource != null) {
                String uriOfSemanticElement = EcoreUtil.getURI((EObject)semanticElement).toString();
                IMarker marker = iresource.createMarker("org.eclipse.papyrus.moka.ui.suspendedmarker");
                marker.setAttribute("uri", (Object)uriOfSemanticElement);
                eObjectToSuspendedMarker.put(semanticElement, (IPapyrusMarker)PapyrusMarkerAdapter.wrap((Resource)semanticElement.eResource(), (IMarker)marker));
            }
        }
        catch (CoreException ce) {
            Activator.log.error((Throwable)ce);
        }
    }

    public void removeSuspendedMarker(IThread thread) {
        for (EObject key : eObjectToSuspendedMarker.keySet()) {
            IPapyrusMarker stackFrameMarker = eObjectToSuspendedMarker.get(key);
            try {
                stackFrameMarker.delete();
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        eObjectToSuspendedMarker.clear();
    }

    public void addAnimationMarker(EObject semanticElement) {
        if (eObjectToAnimationMarker.get(semanticElement) != null) {
            return;
        }
        if (semanticElement.eIsProxy()) {
            semanticElement = AnimationUtils.resolve(semanticElement);
        }
        IResource iresource = MokaBreakpoint.getIResource((Resource)semanticElement.eResource());
        try {
            if (iresource != null) {
                String uriOfSemanticElement = EcoreUtil.getURI((EObject)semanticElement).toString();
                if (MokaConstants.MOKA_OPEN_DIAGRAM_IN_AUTOMATIC_ANIMATION) {
                    List<Diagram> diagrams = this.getDiagrams(semanticElement);
                    for (Diagram d : diagrams) {
                        this.openDiagram(d, false);
                    }
                }
                IMarker marker = iresource.createMarker("org.eclipse.papyrus.moka.ui.animationmarker");
                marker.setAttribute("uri", (Object)uriOfSemanticElement);
                eObjectToAnimationMarker.put(semanticElement, (IPapyrusMarker)PapyrusMarkerAdapter.wrap((Resource)semanticElement.eResource(), (IMarker)marker));
            }
        }
        catch (CoreException ce) {
            Activator.log.error((Throwable)ce);
        }
    }

    public void removeAnimationMarker(EObject semanticElement) {
        IPapyrusMarker animationFrameMarker;
        if (semanticElement.eIsProxy()) {
            semanticElement = AnimationUtils.resolve(semanticElement);
        }
        if ((animationFrameMarker = eObjectToAnimationMarker.get(semanticElement)) != null) {
            try {
                animationFrameMarker.delete();
                eObjectToAnimationMarker.remove(semanticElement);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public static EObject resolve(EObject semanticElement) {
        if (semanticElement.eIsProxy()) {
            AnimationUtils.getInstance().resetDiagrams(semanticElement);
            IEditorPart part = EditorUtils.getEditorPart((EObject)semanticElement);
            ServicesRegistry registry = (ServicesRegistry)part.getAdapter(ServicesRegistry.class);
            ResourceSet resourceSet = null;
            try {
                resourceSet = (ResourceSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException e) {
                resourceSet = new ResourceSetImpl();
            }
            semanticElement = EcoreUtil.resolve((EObject)semanticElement, (ResourceSet)resourceSet);
        }
        return semanticElement;
    }

    public boolean isAnimationMarkerApplied(EObject element) {
        return eObjectToAnimationMarker.get(element) != null;
    }

    protected class OpenDiagramCommand
    extends RecordingCommand {
        protected Diagram diagram;
        protected IPageManager pageMngr;

        public OpenDiagramCommand(Diagram diagram, IPageManager pageMngr, TransactionalEditingDomain domain) {
            super(domain);
            this.diagram = diagram;
            this.pageMngr = pageMngr;
        }

        protected void doExecute() {
            this.pageMngr.openPage((Object)this.diagram);
            this.pageMngr.selectPage((Object)this.diagram);
        }
    }
}

