/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.presentation;

import java.util.List;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.moka.debug.MokaBreakpoint;
import org.eclipse.papyrus.moka.debug.MokaStackFrame;
import org.eclipse.papyrus.moka.launch.EditorUtils;
import org.eclipse.papyrus.moka.ui.presentation.AnimationUtils;
import org.eclipse.papyrus.moka.ui.presentation.IPresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class MokaDebugModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        EObject modelElement = null;
        if (element instanceof MokaBreakpoint) {
            modelElement = ((MokaBreakpoint)element).getModelElement();
        } else if (element instanceof EObject) {
            modelElement = (EObject)element;
        }
        if (modelElement == null) {
            return null;
        }
        FileEditorInput input = EditorUtils.getFileEditorInput((EObject)modelElement);
        return input;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return "org.eclipse.papyrus.infra.core.papyrusEditor";
    }

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof IPresentation) {
            return ((IPresentation)element).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IPresentation) {
            return ((IPresentation)element).getLabel();
        }
        if (element instanceof MokaBreakpoint) {
            return ((MokaBreakpoint)element).getLabel();
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail;
        if (value instanceof IPresentation && (detail = ((IPresentation)value).getDetails()) != null) {
            listener.detailComputed(value, detail);
        }
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        if (frame instanceof MokaStackFrame) {
            MokaStackFrame stackFrame = (MokaStackFrame)frame;
            EObject modelElement = stackFrame.getModelElement();
            if (modelElement.eIsProxy()) {
                AnimationUtils.getInstance().resetDiagrams(modelElement);
                ServicesRegistry servicesRegistry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class);
                ResourceSet resourceSet = null;
                try {
                    resourceSet = (ResourceSet)servicesRegistry.getService(ModelSet.class);
                }
                catch (ServiceException e) {
                    resourceSet = new ResourceSetImpl();
                }
                modelElement = EcoreUtil.resolve((EObject)modelElement, (ResourceSet)resourceSet);
            }
            List<Diagram> diagrams = AnimationUtils.getInstance().getDiagrams(modelElement);
            for (Diagram diagram : diagrams) {
                AnimationUtils.getInstance().openDiagram(diagram, false);
            }
            AnimationUtils.getInstance().addSuspendedMarker(modelElement);
            return true;
        }
        return false;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        AnimationUtils.getInstance().removeSuspendedMarker(thread);
    }
}

