/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.dialogs;

import java.util.Arrays;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.FCM.Connector;
import org.eclipse.papyrus.FCM.InteractionComponent;
import org.eclipse.papyrus.infra.widgets.toolbox.utils.DialogUtils;
import org.eclipse.papyrus.qompass.designer.core.Description;
import org.eclipse.papyrus.qompass.designer.core.Log;
import org.eclipse.papyrus.qompass.designer.core.Utils;
import org.eclipse.papyrus.qompass.designer.core.templates.ConnectorBinding;
import org.eclipse.papyrus.qompass.designer.core.transformations.TransformationException;
import org.eclipse.papyrus.qompass.designer.ui.dialogs.QNameLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConnectorSelectionDialog
extends AbstractElementListSelectionDialog {
    protected Package m_model;
    protected EList<Package> visitedPackages;
    protected Text m_description;
    protected Button fTypeOnly;
    private EList<Class> connectorList = new BasicEList();
    private Feature m_selectedConnector;
    private Object[] fUpperElements;
    protected FilteredList fUpper;
    protected FilteredList fLower;
    private InteractionComponent initialSelection = null;

    public ConnectorSelectionDialog(Shell parent, Package model, Feature selectedConnector) {
        super(parent, (ILabelProvider)new QNameLabelProvider());
        this.visitedPackages = new BasicEList();
        this.getAllConnectors(model, selectedConnector, this.connectorList);
        this.m_selectedConnector = selectedConnector;
        this.setMultipleSelection(false);
        this.m_model = model;
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        GridData gridData = DialogUtils.createFillGridData();
        gridData.heightHint = 200;
        Group fUpperGroup = new Group(contents, 0);
        fUpperGroup.setLayout((Layout)new GridLayout());
        fUpperGroup.setLayoutData((Object)gridData);
        fUpperGroup.setText(" Abstract interaction components ");
        this.createFilterText((Composite)fUpperGroup);
        this.fUpper = this.createFilteredList((Composite)fUpperGroup);
        final Group fLowerGroup = new Group(contents, 0);
        fLowerGroup.setLayout((Layout)new GridLayout());
        fLowerGroup.setLayoutData((Object)gridData);
        fLowerGroup.setText(" Realizations/groups of interaction components ");
        this.fLower = this.createFilteredList((Composite)fLowerGroup);
        this.fFilteredList = this.fUpper;
        Connector fcmConnector = (Connector)UMLUtil.getStereotypeApplication((Element)this.m_selectedConnector, Connector.class);
        this.initialSelection = fcmConnector != null ? fcmConnector.getIc() : null;
        this.fTypeOnly = new Button(contents, 32);
        this.fTypeOnly.setText("Select type only");
        SelectionListener fTypeOnlySL = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectorSelectionDialog.this.fTypeOnly.getSelection()) {
                    ConnectorSelectionDialog.this.fLower.setEnabled(false);
                    fLowerGroup.setEnabled(false);
                    ConnectorSelectionDialog.this.fLower.setSelection(new int[0]);
                    ConnectorSelectionDialog.this.fLower.setElements(null);
                } else {
                    ConnectorSelectionDialog.this.fLower.setEnabled(true);
                    fLowerGroup.setEnabled(true);
                    ConnectorSelectionDialog.this.handleSelectionChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fTypeOnly.addSelectionListener(fTypeOnlySL);
        this.fUpper.setElements(this.connectorList.toArray());
        if (this.initialSelection instanceof InteractionComponent) {
            InteractionComponent componentComp = this.initialSelection;
            Class componentCompBase = componentComp.getBase_Class();
            if (!componentCompBase.isAbstract()) {
                Class componentTypeBase = Utils.componentType((Class)componentCompBase);
                componentComp = (InteractionComponent)UMLUtil.getStereotypeApplication((Element)componentTypeBase, InteractionComponent.class);
            } else {
                this.fTypeOnly.setSelection(true);
            }
            fTypeOnlySL.widgetSelected(null);
            this.fUpper.setSelection(new Object[]{componentComp.getBase_Class()});
        }
        Label info = this.createMessageArea(contents);
        info.setText("Information about connector implementation:");
        GridData descriptionGD = new GridData();
        descriptionGD.horizontalAlignment = 4;
        descriptionGD.grabExcessHorizontalSpace = true;
        descriptionGD.heightHint = 80;
        descriptionGD.grabExcessVerticalSpace = true;
        descriptionGD.verticalAlignment = 4;
        this.m_description = new Text(contents, 584);
        this.m_description.setLayoutData((Object)descriptionGD);
        this.fLower.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selected = ConnectorSelectionDialog.this.fLower.getSelection();
                if (selected.length > 0 && selected[0] instanceof NamedElement) {
                    NamedElement selectedNE = (NamedElement)selected[0];
                    ConnectorSelectionDialog.this.m_description.setText(Description.getDescription((Element)selectedNE));
                } else {
                    ConnectorSelectionDialog.this.m_description.setText("");
                    ConnectorSelectionDialog.this.updateOkState();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return contents;
    }

    protected void updateOkState() {
        if (this.fTypeOnly.getSelection()) {
            super.updateOkState();
        } else {
            Button okButton = this.getOkButton();
            if (okButton != null) {
                okButton.setEnabled(this.fLower.getSelection().length != 0);
            }
        }
    }

    protected Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    protected void computeResult() {
        Object[] result = new Object[]{this.getSelectedElement(this.fTypeOnly.getSelection())};
        this.setResult(Arrays.asList(result));
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection() && this.getSelectedElement(false) != null) {
            this.buttonPressed(0);
        }
    }

    protected void handleSelectionChanged() {
        this.handleUpperSelectionChanged();
    }

    private void handleUpperSelectionChanged() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.fUpperElements = this.getFoldedElements(index);
            if (this.fUpperElements == null || this.fTypeOnly.getSelection()) {
                this.fLower.setElements(new Object[0]);
            } else {
                this.fLower.setElements(this.getLowerList(this.fUpperElements[0]));
                if (this.initialSelection instanceof InteractionComponent) {
                    this.fLower.setSelection(new Object[]{this.initialSelection});
                    this.initialSelection = null;
                }
            }
        }
        this.validateCurrentSelection();
    }

    protected Object getSelectedElement(boolean upper) {
        Object[] selection = upper ? this.fFilteredList.getSelection() : this.fLower.getSelection();
        if (selection.length > 0) {
            return selection[0];
        }
        return null;
    }

    protected Object[] getLowerList(Object selectedUpperObj) {
        UniqueEList connectorList = new UniqueEList();
        if (selectedUpperObj instanceof Class) {
            this.visitedPackages = new BasicEList();
            this.getImplGroups(this.m_model, (Class)selectedUpperObj, (EList<Class>)connectorList);
        }
        return connectorList.toArray();
    }

    void getAllConnectors(Package pkg, Feature selectedConnector, EList<Class> connectorList) {
        for (Element el : pkg.getMembers()) {
            if (el instanceof Package) {
                if (this.visitedPackages.contains((Object)el)) continue;
                this.visitedPackages.add((Object)((Package)el));
                this.getAllConnectors((Package)el, selectedConnector, connectorList);
                continue;
            }
            if (!(el instanceof Class) || !StereotypeUtil.isApplied((Element)el, InteractionComponent.class) || !Utils.isCompType((Class)((Class)el))) continue;
            if (selectedConnector == null) {
                connectorList.add((Object)((Class)el));
                continue;
            }
            try {
                Element owner = selectedConnector.getOwner();
                if (owner instanceof Class) {
                    Class composite = (Class)owner;
                    Log.log((int)1, (int)128, (String)("ConnectorSelectionDialog.getAllConnectors: try to bind connector " + ((Class)el).getQualifiedName()));
                    ConnectorBinding.obtainBinding((Class)composite, (Feature)selectedConnector, (Class)((Class)el), (boolean)false);
                    connectorList.add((Object)((Class)el));
                    continue;
                }
                connectorList.add((Object)((Class)el));
            }
            catch (TransformationException transformationException) {
                // empty catch block
            }
        }
    }

    void getImplGroups(Package pkg, Class selectedConnType, EList<Class> implGroupList) {
        for (Element el : pkg.getMembers()) {
            Class class_;
            if (el instanceof Package) {
                if (this.visitedPackages.contains((Object)el)) continue;
                this.visitedPackages.add((Object)((Package)el));
                this.getImplGroups((Package)el, selectedConnType, implGroupList);
                continue;
            }
            if (!(el instanceof Class) || (class_ = (Class)el).getGeneralization((Classifier)selectedConnType) == null) continue;
            implGroupList.add((Object)((Class)el));
        }
    }
}

