/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.dialogs;

import java.util.Arrays;
import org.eclipse.papyrus.qompass.designer.core.generate.GenerationOptions;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class GenerationOptionsDialog
extends SelectionStatusDialog
implements GenerationOptions {
    protected Button fButtonModelOnly;
    protected Button fButtonRewriteSettings;
    protected Button fButtonOnlyChanged;
    protected Button fButtonCACOnly;
    public static int oldResultInt = 0;

    public GenerationOptionsDialog(Shell parent) {
        super(parent);
    }

    protected void computeResult() {
        int resultInt;
        oldResultInt = resultInt = (this.isRewriteSettings() ? 1 : 0) + (this.isOnlyChanged() ? 2 : 0) + (this.isModelOnly() ? 4 : 0) + (this.isCACOnly() ? 8 : 0);
        Object[] result = new Object[]{resultInt};
        this.setResult(Arrays.asList(result));
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.fButtonCACOnly = new Button(contents, 32);
        this.fButtonCACOnly.setText("Only perform container and connector expansion (intermediate model without code generation)");
        this.fButtonCACOnly.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenerationOptionsDialog.this.updateButtonEnableStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fButtonCACOnly.setSelection((oldResultInt & 8) != 0);
        this.fButtonModelOnly = new Button(contents, 32);
        this.fButtonModelOnly.setText("Only generate model (not code)");
        this.fButtonModelOnly.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean modelOnly = GenerationOptionsDialog.this.fButtonModelOnly.getSelection();
                GenerationOptionsDialog.this.fButtonOnlyChanged.setEnabled(!modelOnly);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fButtonModelOnly.setSelection((oldResultInt & 4) != 0);
        this.fButtonRewriteSettings = new Button(contents, 32);
        this.fButtonRewriteSettings.setText("Rewrite project settings, if project exists already (may overwrite user settings)");
        this.fButtonRewriteSettings.setSelection((oldResultInt & 1) != 0);
        this.fButtonOnlyChanged = new Button(contents, 32);
        this.fButtonOnlyChanged.setText("Experimental: only write types that have changed (based on a difference model via EMF compare)");
        this.fButtonOnlyChanged.setSelection((oldResultInt & 2) != 0);
        this.updateButtonEnableStatus();
        return contents;
    }

    protected void updateButtonEnableStatus() {
        boolean onlyCAC = this.fButtonCACOnly.getSelection();
        boolean modelOnly = this.fButtonModelOnly.getSelection();
        this.fButtonModelOnly.setEnabled(!onlyCAC);
        this.fButtonOnlyChanged.setEnabled(!modelOnly && !onlyCAC);
        this.fButtonRewriteSettings.setEnabled(!onlyCAC);
    }

    public boolean isRewriteSettings() {
        return this.fButtonRewriteSettings.getSelection();
    }

    public boolean isOnlyChanged() {
        return this.fButtonOnlyChanged.getSelection();
    }

    public boolean isModelOnly() {
        return this.fButtonModelOnly.getSelection();
    }

    public boolean isCACOnly() {
        return this.fButtonCACOnly.getSelection();
    }
}

