/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.qompass.designer.core.CommandSupport;
import org.eclipse.papyrus.qompass.designer.core.commands.AddMarteAndFcmProfile;
import org.eclipse.papyrus.qompass.designer.core.commands.AddQompassModelLibs;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;

public class AddProfileAndModelLibsHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof Package;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!(this.selectedEObject instanceof Package)) {
            return null;
        }
        Package selectedPkg = (Package)this.selectedEObject;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)selectedPkg);
        AddMarteAndFcmProfile addProfiles = new AddMarteAndFcmProfile(selectedPkg, 7, domain);
        AddQompassModelLibs addModelLibs = new AddQompassModelLibs(selectedPkg, domain);
        ListSelectionDialog dialog = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)addModelLibs.getAvailableImportPackages().toArray(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(){

            public String getText(Object pi) {
                return ((PackageImport)pi).getImportedPackage().getName();
            }
        }, "Select Qompass model libraries for package import.\nLibraries that are already imported, are selected. Please note that additional\nQompass model library might be loaded with the standard \"import registered library\" option\n\nPressing \"Ok\" will continue with the application of the FCM profile and (parts of) the MARTE profile\n");
        dialog.setTitle("Select import library");
        dialog.setInitialElementSelections((List)addModelLibs.getAlreadyImportedPackages());
        int result = dialog.open();
        if (result == 0) {
            addModelLibs.setImportList(dialog.getResult());
            CommandSupport.exec((IUndoableOperation)addModelLibs);
            CommandSupport.exec((IUndoableOperation)addProfiles);
        }
        return null;
    }
}

