/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.qompass.designer.core.CommandSupport;
import org.eclipse.papyrus.qompass.designer.core.RunnableWithResult;
import org.eclipse.papyrus.qompass.designer.ui.dialogs.ConfigureInstanceDialog;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class ConfigureInstanceHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof Class || this.selectedEObject instanceof Connector || this.selectedEObject instanceof Property || this.selectedEObject instanceof InstanceSpecification;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!(this.selectedEObject instanceof NamedElement)) {
            return null;
        }
        final NamedElement element = (NamedElement)this.selectedEObject;
        final Shell shell = Display.getDefault().getActiveShell();
        final ExecutionEvent from = event;
        if (element instanceof Class) {
            CommandSupport.exec((String)"Configure associated component instance", (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                public CommandResult run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((Class)element, from)) {
                        configureInstanceDialog.setTitle("Configure instance");
                        configureInstanceDialog.setMessage("Configure instance for component " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            });
        } else if (element instanceof Feature) {
            CommandSupport.exec((String)"Configure associated instance", (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                public CommandResult run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((Feature)element, from)) {
                        configureInstanceDialog.setTitle("Configure instance");
                        configureInstanceDialog.setMessage("Configure instance for property/connector " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            });
        } else if (element instanceof InstanceSpecification) {
            CommandSupport.exec((String)"Configure instance", (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                public CommandResult run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((InstanceSpecification)element, from)) {
                        configureInstanceDialog.setMessage("Configure instance " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return CommandResult.newOKCommandResult();
                        }
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            });
        }
        return null;
    }
}

