/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.FCM.DeploymentPlan;
import org.eclipse.papyrus.qompass.designer.core.CommandSupport;
import org.eclipse.papyrus.qompass.designer.core.RunnableWithResult;
import org.eclipse.papyrus.qompass.designer.core.Utils;
import org.eclipse.papyrus.qompass.designer.core.deployment.DepCreation;
import org.eclipse.papyrus.qompass.designer.core.deployment.DepPlanUtils;
import org.eclipse.papyrus.qompass.designer.core.sync.DepPlanSync;
import org.eclipse.papyrus.qompass.designer.core.transformations.TransformationException;
import org.eclipse.papyrus.qompass.designer.ui.Messages;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class CreateDepPlanHandler
extends CmdHandler {
    private Package depPlans;

    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof Class && Utils.isCompImpl((Classifier)((Class)this.selectedEObject));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!(this.selectedEObject instanceof Class)) {
            return null;
        }
        final Class selectedComposite = (Class)this.selectedEObject;
        CommandSupport.exec((String)Messages.CreateDepPlanHandler_CreateDPs, (ExecutionEvent)event, (Runnable)new Runnable(){

            @Override
            public void run() {
                CreateDepPlanHandler.this.depPlans = DepPlanUtils.getDepPlanRoot((Element)selectedComposite);
            }
        });
        try {
            String name = String.valueOf(selectedComposite.getName()) + "DepPlan";
            if (this.depPlans.getMember(name) != null) {
                Shell shell = Display.getDefault().getActiveShell();
                String[] dialogButtonLabels = new String[]{Messages.CreateDepPlanHandler_Cancel, Messages.CreateDepPlanHandler_Sync, Messages.CreateDepPlanHandler_CreateNew};
                MessageDialog dialog = new MessageDialog(shell, Messages.CreateDepPlanHandler_WhatShouldIDo, null, String.format(Messages.CreateDepPlanHandler_DPwithNameExistsAlready, name), 3, dialogButtonLabels, 0);
                int result = dialog.open();
                if (result == 0) {
                    return null;
                }
                if (result == 1) {
                    NamedElement existing = this.depPlans.getMember(name);
                    if (existing instanceof Package) {
                        DepPlanSync.syncDepPlan((Package)((Package)existing));
                    } else {
                        MessageDialog.openError((Shell)shell, (String)Messages.CreateDepPlanHandler_CannotSync, (String)String.format(Messages.CreateDepPlanHandler_DPwithNameExistsNoPackage, name));
                    }
                } else {
                    int i = 2;
                    while (this.depPlans.getMember(name = String.valueOf(selectedComposite.getName()) + "DepPlan" + i) != null) {
                        ++i;
                    }
                }
            }
            final String depPlanName = name;
            CommandSupport.exec((String)Messages.CreateDepPlanHandler_CreateDP, (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                public CommandResult run() {
                    Package cdp = CreateDepPlanHandler.this.depPlans.createNestedPackage(depPlanName);
                    Stereotype st = StereotypeUtil.apply((Element)cdp, DeploymentPlan.class);
                    if (st == null) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CreateDepPlanHandler_CannotCreateDP, (String)Messages.CreateDepPlanHandler_StereoApplicationFailed);
                        return CommandResult.newErrorCommandResult((String)Messages.CreateDepPlanHandler_CannotCreateDP);
                    }
                    try {
                        InstanceSpecification newRootIS = DepCreation.createDepPlan((Package)cdp, (Class)selectedComposite, (String)"mainInstance", (boolean)true);
                        DepCreation.initAutoValues((InstanceSpecification)newRootIS);
                        return CommandResult.newOKCommandResult();
                    }
                    catch (TransformationException e) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CreateDepPlanHandler_CannotCreateDP, (String)e.getMessage());
                        return CommandResult.newErrorCommandResult((String)e.getMessage());
                    }
                }
            });
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

