/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.qompass.designer.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.FCM.DeploymentPlan;
import org.eclipse.papyrus.qompass.designer.core.CommandSupport;
import org.eclipse.papyrus.qompass.designer.core.RunnableWithResult;
import org.eclipse.papyrus.qompass.designer.core.Utils;
import org.eclipse.papyrus.qompass.designer.core.sync.CompImplSync;
import org.eclipse.papyrus.qompass.designer.core.sync.DepPlanSync;
import org.eclipse.papyrus.qompass.designer.core.sync.InterfaceSync;
import org.eclipse.papyrus.qompass.designer.core.transformations.TransformationRTException;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class SyncHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Property) {
            this.selectedEObject = ((Property)this.selectedEObject).getType();
        }
        if (this.selectedEObject instanceof Interface) {
            return true;
        }
        return this.selectedEObject instanceof Class ? Utils.isComponent((Class)((Class)this.selectedEObject)) : this.selectedEObject instanceof Package && StereotypeUtil.isApplied((Element)((Package)this.selectedEObject), DeploymentPlan.class);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof Property) {
            this.selectedEObject = ((Property)this.selectedEObject).getType();
        }
        if (this.selectedEObject instanceof Interface) {
            final Interface selectedIntf = (Interface)this.selectedEObject;
            CommandSupport.exec((String)"Synchronize interface", (ExecutionEvent)event, (Runnable)new Runnable(){

                @Override
                public void run() {
                    InterfaceSync.syncSignalReceptionSupport((Interface)selectedIntf);
                }
            });
        } else if (this.selectedEObject instanceof Class) {
            final Class selectedClass = (Class)this.selectedEObject;
            if (Utils.isCompImpl((Classifier)selectedClass)) {
                CommandSupport.exec((String)"Synchronize component via implementation", (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                    public CommandResult run() {
                        CompImplSync.updatePorts((Class)selectedClass);
                        try {
                            CompImplSync.syncRealizations((Class)selectedClass);
                        }
                        catch (TransformationRTException e) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Problems during synchronization", (String)e.getMessage());
                            return CommandResult.newErrorCommandResult((String)e.getMessage());
                        }
                        CompImplSync.interfaceModifications((Class)selectedClass, null);
                        return CommandResult.newOKCommandResult();
                    }
                });
            } else if (Utils.isCompType((Class)selectedClass)) {
                CommandSupport.exec((String)"Synchronize component via type", (ExecutionEvent)event, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!CompImplSync.syncViaType((Class)selectedClass, (boolean)false)) {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning: ineffective command", (String)"Synchronization applied on a component type (abstract class) will synchronize all implementations, i.e. non-abstract classes inheriting from it. However, the selected type has no implementations");
                        }
                    }
                });
            }
        } else if (this.selectedEObject instanceof Package) {
            final Package selectedPkg = (Package)this.selectedEObject;
            CommandSupport.exec((String)"Synchronize deployment plan", (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                public CommandResult run() {
                    try {
                        DepPlanSync.syncDepPlan((Package)selectedPkg);
                        return CommandResult.newOKCommandResult();
                    }
                    catch (TransformationRTException e) {
                        Shell shell = Display.getDefault().getActiveShell();
                        MessageDialog.openError((Shell)shell, (String)"Can not synchronize deployment plan", (String)e.getMessage());
                        return CommandResult.newErrorCommandResult((String)e.getMessage());
                    }
                }
            });
        }
        return null;
    }
}

