/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis.AbstractionRule;
import org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis.DeriveReqRule;
import org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis.ITracabilityRule;
import org.eclipse.papyrus.req.sysml.traceabilityassistant.analysis.SatisfyRule;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class TracabilityAnalyzer {
    private ArrayList<Element> blackbox = new ArrayList();
    private ArrayList<ITracabilityRule> tracabilityRules = new ArrayList();

    public TracabilityAnalyzer() {
        this.tracabilityRules.add(new AbstractionRule());
        this.tracabilityRules.add(new SatisfyRule());
        this.tracabilityRules.add(new DeriveReqRule());
    }

    public void runAnalysis(Package model, TransactionalEditingDomain domain) {
        HashMap interestingElement = new HashMap();
        for (Element currentElement : model.allOwnedElements()) {
            if (this.blackbox.contains(currentElement)) continue;
            for (ITracabilityRule tracabilityRule : this.tracabilityRules) {
                if (!tracabilityRule.canApplyTracability(currentElement)) continue;
                if (interestingElement.containsKey(currentElement)) {
                    ((ArrayList)interestingElement.get(currentElement)).add(tracabilityRule);
                    continue;
                }
                interestingElement.put(currentElement, new ArrayList());
                ((ArrayList)interestingElement.get(currentElement)).add(tracabilityRule);
            }
        }
        for (Element currentKey : interestingElement.keySet()) {
            for (ITracabilityRule iTracabilityRule : (ArrayList)interestingElement.get(currentKey)) {
                iTracabilityRule.applyTracability(currentKey, domain);
            }
        }
    }
}

