/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.soaml.diagram.common.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.communication.custom.helper.RotationHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class PortNodeLabelDisplayEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public void notifyChanged(Notification notification) {
        Object feature = notification.getFeature();
        if (feature == NotationPackage.eINSTANCE.getLocation_X() || feature == NotationPackage.eINSTANCE.getLocation_Y()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PortNodeLabelDisplayEditPolicy.this.refreshStereotypeDisplay();
                }
            });
        }
        super.notifyChanged(notification);
    }

    public Image stereotypeIconToDisplay() {
        EList stereotype_list = this.getUMLElement().getAppliedStereotypes();
        if (stereotype_list.size() != 0) {
            Stereotype stereotype = (Stereotype)stereotype_list.get(0);
            if (stereotype.getName().equals("Request") || stereotype.getName().equals("Service")) {
                Image icon = Activator.getIconElement((Element)this.getUMLElement(), (Stereotype)stereotype, (boolean)false);
                IFigure portView = this.getHostFigure();
                IFigure parentView = portView.getParent().getParent();
                Rectangle parentBounds = parentView.getBounds();
                Rectangle portBounds = portView.getBounds();
                if (portBounds.x() <= parentBounds.x()) {
                    return icon;
                }
                if (portBounds.x() >= parentBounds.right() - portBounds.width()) {
                    return new Image(icon.getDevice(), RotationHelper.rotateImage((Image)icon, (double)180.0), 0);
                }
                if (portBounds.y() <= parentBounds.y()) {
                    return new Image(icon.getDevice(), RotationHelper.rotateImage((Image)icon, (double)90.0), 0);
                }
                if (portBounds.y() >= parentBounds.bottom() - portBounds.height()) {
                    return new Image(icon.getDevice(), RotationHelper.rotateImage((Image)icon, (double)-90.0), 0);
                }
                return null;
            }
            return Activator.getIconElement((Element)this.getUMLElement(), (Stereotype)stereotype, (boolean)false);
        }
        return null;
    }
}

