/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.soaml.diagram.common.utils;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.papyrus.soaml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;

public class SoamlSelectionTester
extends PropertyTester {
    public static final String IS_SOAML_MODEL = "isSoamlModel";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof IMultiDiagramEditor)) {
            return false;
        }
        Boolean currentValue = null;
        if (IS_SOAML_MODEL.equals(property)) {
            currentValue = this.testSoamlModelNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testSoamlModelNature(Object receiver) {
        boolean isSoamlModel = false;
        EObject root = this.getRoot(receiver);
        if (root instanceof Package) {
            return ((Package)root).getAppliedProfile("SoaML") != null;
        }
        return isSoamlModel;
    }

    private EObject getRoot(Object receiver) {
        EObject root = null;
        if (receiver instanceof ISelection) {
            ISelection selection = (ISelection)receiver;
            if (selection.isEmpty()) {
                return null;
            }
            try {
                IStructuredSelection selectionstructured = (IStructuredSelection)selection;
                Object selectedElement = selectionstructured.getFirstElement();
                Object selectedAdapter = Platform.getAdapterManager().getAdapter(selectedElement, IFile.class);
                if (selectedAdapter instanceof IFile) {
                    IFile selectedFile = (IFile)selectedAdapter;
                    ModelSet modelSet = new ModelSet();
                    ModelsReader reader = new ModelsReader();
                    reader.readModel(modelSet);
                    IPath workspacePath = selectedFile.getFullPath();
                    URI workspaceURI = URI.createPlatformResourceURI((String)workspacePath.toString(), (boolean)true);
                    modelSet.loadModels(workspaceURI);
                    UmlModel openedModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                    if (openedModel != null) {
                        root = openedModel.lookupRoot();
                    }
                } else {
                    ServiceUtilsForSelection serviceUtils = ServiceUtilsForSelection.getInstance();
                    UmlModel openedModel = (UmlModel)serviceUtils.getModelSet((Object)selection).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                    if (openedModel != null) {
                        root = openedModel.lookupRoot();
                    }
                }
            }
            catch (ServiceException selectionstructured) {
            }
            catch (NotFoundException e) {
                Activator.log.error((Throwable)e);
            }
            catch (ModelMultiException e) {
                e.printStackTrace();
            }
        }
        return root;
    }
}

