/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.properties.xtext.sheet;

import com.google.inject.Injector;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.alf.properties.xtext.sheet.tooling.StyledTextWithUndoRedo;
import org.eclipse.papyrus.uml.alf.properties.xtext.sheet.ui.listeners.CommitButtonSelectionListener;
import org.eclipse.papyrus.uml.alf.properties.xtext.sheet.ui.listeners.EditorFocusListener;
import org.eclipse.papyrus.uml.alf.text.generation.DefaultEditStringRetrievalStrategy;
import org.eclipse.papyrus.uml.alf.transaction.job.AlfJobObserver;
import org.eclipse.papyrus.uml.alf.ui.internal.AlfActivator;
import org.eclipse.papyrus.uml.alf.validation.ModelNamespaceFacade;
import org.eclipse.papyrus.uml.xtext.integration.StyledTextXtextAdapter;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtext.resource.XtextResource;

public class AlfEditionPropertySection
extends AbstractModelerPropertySection
implements ContextElementAdapter.IContextElementProvider {
    private FormToolkit toolkit;
    private Form form;
    private StyledTextWithUndoRedo textControl;
    private Button commitButton;
    private StyledTextXtextAdapter styledTextAdapter;
    private final ContextElementAdapter contextElementAdapter = new ContextElementAdapter((ContextElementAdapter.IContextElementProvider)this);
    protected boolean isUndo;
    protected boolean isRedo;
    private DefaultEditStringRetrievalStrategy alfSerialization = new DefaultEditStringRetrievalStrategy();
    private Injector alfToolingInjector = AlfActivator.getInstance().getInjector("org.eclipse.papyrus.uml.alf.Alf");
    private EObject previousEObject = null;

    public StyledText getEditor() {
        return this.textControl;
    }

    public void refresh() {
        String serialization = "/*Error: serialization could not be computed*/";
        if (this.eObject != null) {
            serialization = this.alfSerialization.getEditString(this.getEditableObject(this.eObject));
        }
        if (this.previousEObject != this.eObject) {
            this.updateXtextAdapters((Control)this.textControl);
            this.previousEObject = this.eObject;
        }
        this.textControl.setText(serialization);
        if (this.textControl != null) {
            this.textControl.setEnabled(!this.isReadOnly());
        }
    }

    private Element getEditableObject(EObject edited) {
        if (edited instanceof Operation) {
            return (Element)((Operation)edited).getMethods().get(0);
        }
        return (Element)edited;
    }

    private Namespace getNamespace(Element element) {
        if (element != null && element instanceof NamedElement) {
            Element edited = this.getEditableObject((EObject)element);
            return ((NamedElement)edited).getNamespace();
        }
        return null;
    }

    private void installValidationContextFor(Element element) {
        XtextResource resource;
        if (this.styledTextAdapter != null && (resource = this.styledTextAdapter.getFakeResourceContext().getFakeResource()) != null) {
            ModelNamespaceFacade.getInstance().createValidationContext((Resource)resource, this.getNamespace(element));
        }
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.styledTextAdapter != null) {
            this.styledTextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    public final void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.setBorderStyle(2048);
        super.createControls(parent, aTabbedPropertySheetPage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        this.createTextControl(this.form.getBody());
        this.createPushButton(this.form.getBody());
    }

    protected void createPushButton(Composite parent) {
        final AlfJobObserver observer = new AlfJobObserver(this.commitButton);
        this.commitButton = new Button(parent, 8);
        this.commitButton.setText("Commit");
        this.commitButton.setToolTipText("Commit the modifications in your model");
        this.commitButton.setImage(new Image((Device)Display.getDefault(), ((Object)((Object)this)).getClass().getResourceAsStream("/resources/icons/incom_stat.gif")));
        this.commitButton.addSelectionListener((SelectionListener)new CommitButtonSelectionListener(this));
        this.commitButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)observer);
            }
        });
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new AlfJobObserver(this.commitButton));
    }

    protected void createTextControl(Composite parent) {
        this.textControl = new StyledTextWithUndoRedo(parent, 2626);
        this.textControl.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, true).hint(parent.getSize()).applyTo((Control)this.textControl);
        this.textControl.addFocusListener((FocusListener)new EditorFocusListener(this));
    }

    protected void updateXtextAdapters(Control styledText) {
        if (this.styledTextAdapter != null) {
            this.styledTextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
        }
        this.styledTextAdapter = new StyledTextXtextAdapter(this.alfToolingInjector);
        this.styledTextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)this.contextElementAdapter);
        this.installValidationContextFor((Element)this.eObject);
        this.styledTextAdapter.adapt((StyledText)styledText);
    }

    public EObject getContextObject() {
        return this.getEditableObject(this.eObject);
    }

    protected boolean isReadOnly() {
        EObject context = this.getContextObject();
        return context == null || EMFHelper.isReadOnly((EObject)context) || super.isReadOnly();
    }
}

