/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.properties.xtext.sheet;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.alf.preferences.AlfIntegrationPreferencesUtil;
import org.eclipse.papyrus.uml.alf.transaction.observation.listener.filter.FUMLScopeUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;

public class AlfEditorPropertySectionFilter
implements IFilter {
    public boolean select(Object toTest) {
        Element element = this.resolveSemanticElement(toTest);
        boolean accepted = false;
        if (element != null && AlfIntegrationPreferencesUtil.isAlfSupportEnabled()) {
            accepted = this.isValidInput(element);
        }
        return accepted;
    }

    private boolean isValidInput(Element element) {
        if (!this.isModifiable(element)) {
            return false;
        }
        if (FUMLScopeUtil.isClass((Object)element)) {
            return true;
        }
        if (FUMLScopeUtil.isPackage((Object)element)) {
            return true;
        }
        if (FUMLScopeUtil.isSignal((Object)element)) {
            return true;
        }
        if (FUMLScopeUtil.isEnumeration((Object)element)) {
            return true;
        }
        if (FUMLScopeUtil.isDataType((Object)element)) {
            return true;
        }
        if (FUMLScopeUtil.isAssociation((Object)element)) {
            return true;
        }
        if (FUMLScopeUtil.isActivity((Object)element)) {
            return true;
        }
        return FUMLScopeUtil.isOperationWithImplementation((Object)element);
    }

    private boolean isModifiable(Element element) {
        Resource resource = element.eResource();
        if (resource != null) {
            return !EMFHelper.isReadOnly((EObject)element);
        }
        return false;
    }

    private Element resolveSemanticElement(Object selectedElement) {
        return UMLUtil.resolveUMLElement((Object)selectedElement);
    }
}

