/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.text.generation;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.alf.Member;
import org.eclipse.papyrus.uml.alf.PropertyDefinition;
import org.eclipse.papyrus.uml.alf.text.ActivatorText;
import org.eclipse.papyrus.uml.alf.text.generation.EditStringRetrievalStrategy;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.text.representation.util.RepresentationParser;
import org.eclipse.papyrus.uml.alf.text.representation.util.RepresentationParsingError;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public class DefaultEditStringRetrievalStrategy
extends EditStringRetrievalStrategy {
    private ISerializer serializer = (ISerializer)ActivatorText.getDefault().getInjector().getInstance(ISerializer.class);

    public String getGeneratedEditString(Element element) {
        String generated = "";
        Resource alfModel = this.getAlfModel((NamedElement)element);
        if (this.serializer != null) {
            EObject serializationTarget = null;
            serializationTarget = element instanceof Property ? this.getPropertyDefinition((Property)element, alfModel) : (EObject)alfModel.getContents().get(0);
            generated = this.serializer.serialize(serializationTarget, SaveOptions.newBuilder().noValidation().getOptions());
        }
        return generated;
    }

    @Override
    public String getEditString(Element element) {
        AlfTextualRepresentation registeredRep = null;
        try {
            registeredRep = RepresentationParser.getInstance().parse((NamedElement)element);
        }
        catch (RepresentationParsingError e) {
            e.printStackTrace();
        }
        if (registeredRep != null && registeredRep.isDetached()) {
            AlfTextualRepresentation generatedRep = null;
            try {
                generatedRep = RepresentationParser.getInstance().getSnapshot((NamedElement)element);
            }
            catch (RepresentationParsingError e) {
                e.printStackTrace();
            }
            if (generatedRep != null) {
                registeredRep.setText(generatedRep.getContent());
            }
        }
        return registeredRep.getContent();
    }

    private EObject getPropertyDefinition(Property property, Resource alfModelResource) {
        Member memberDefinition = null;
        TreeIterator contentIterator = alfModelResource.getAllContents();
        boolean found = false;
        while (contentIterator.hasNext() && !found) {
            PropertyDefinition definition;
            Member member;
            EObject currentObject = (EObject)contentIterator.next();
            if (!(currentObject instanceof Member) || !(member = (Member)currentObject).getVisibility().equals(property.getVisibility().toString()) || !(member.getDefinition() instanceof PropertyDefinition) || !(definition = (PropertyDefinition)member.getDefinition()).getName().equals(property.getName())) continue;
            found = definition.getTypePart().isIsAny() && property.getType() == null || definition.getTypePart().getTypeName().toString().equals(property.getType().toString());
            memberDefinition = member;
        }
        return memberDefinition;
    }
}

