/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.dialog.ProfilesToExportSelectionDialog;
import org.eclipse.papyrus.uml.export.messages.Messages;
import org.eclipse.papyrus.uml.export.util.ProfileUtil;
import org.eclipse.papyrus.uml.export.util.WSFileUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.uml2.uml.Profile;
import org.osgi.service.prefs.Preferences;

public class EditProfileApplicationAction
extends ActionDelegate
implements IActionDelegate {
    protected List<IFile> files;

    public static IFile getIFile(Object selectedObj) {
        Collection collec;
        IFile result = null;
        if (selectedObj instanceof IFile) {
            result = (IFile)selectedObj;
        }
        if (result == null && selectedObj instanceof IAdaptable) {
            result = (IFile)((IAdaptable)selectedObj).getAdapter(IFile.class);
        }
        if (result == null) {
            result = (IFile)Platform.getAdapterManager().getAdapter(selectedObj, IFile.class);
        }
        if (result == null && (collec = (Collection)Platform.getAdapterManager().getAdapter(selectedObj, Collection.class)) != null) {
            for (Object o : collec) {
                IFile f;
                if (!(o instanceof IFile) || !"uml".equals((f = (IFile)o).getFileExtension())) continue;
                result = f;
                break;
            }
        }
        return result != null && "uml".equals(result.getFileExtension()) ? result : null;
    }

    public static boolean isProfileApplicationEditable(Object selectedObj) {
        IFile file = EditProfileApplicationAction.getIFile(selectedObj);
        if (file != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource umlResource = WSFileUtil.loadResource(file.getFullPath().toString(), (ResourceSet)resourceSet);
            if (umlResource.getContents().isEmpty()) {
                return false;
            }
            EObject root = (EObject)umlResource.getContents().get(0);
            Object[] appliedProfiles = ProfileUtil.getAppliedProfilesFromWS(root);
            if (appliedProfiles != null) {
                int i = 0;
                while (i < appliedProfiles.length) {
                    String installedProfileURI = EditProfileApplicationAction.findCorrespondingInstalledProfile((Profile)appliedProfiles[i]);
                    if (installedProfileURI != null) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.files = ((IStructuredSelection)selection).toList();
        }
    }

    public void run(IAction action) {
        if (this.files != null) {
            Iterator<IFile> filesIt = this.files.iterator();
            final IFile file = filesIt.next();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(file.getFullPath(), null);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            final ITextFileBuffer buffer = manager.getTextFileBuffer(file.getFullPath());
            final IDocument doc = buffer.getDocument();
            final FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
            final MultiTextEdit multiEdit = new MultiTextEdit();
            final Resource umlResource = WSFileUtil.loadResource(file.getFullPath().toString(), (ResourceSet)resourceSet);
            if (umlResource.getContents().isEmpty()) {
                try {
                    throw new NotFoundException(Messages.EditProfileApplicationAction_0);
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
            EObject root = (EObject)umlResource.getContents().get(0);
            Object[] appliedProfiles = ProfileUtil.getAppliedProfilesFromWS(root);
            ArrayList<Object> appliedLocalProfiles = new ArrayList<Object>();
            int i = 0;
            while (i < appliedProfiles.length) {
                String installedProfileURI = EditProfileApplicationAction.findCorrespondingInstalledProfile((Profile)appliedProfiles[i]);
                if (installedProfileURI != null) {
                    appliedLocalProfiles.add(appliedProfiles[i]);
                }
                ++i;
            }
            if (appliedLocalProfiles != null && !appliedLocalProfiles.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                final ProfilesToExportSelectionDialog dialog = new ProfilesToExportSelectionDialog(shell, true, appliedLocalProfiles.toArray(), "Change profile application from local to installed");
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    IRunnableWithProgress operation = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            Object[] profiles = dialog.getResult();
                            int i = 0;
                            while (i < profiles.length) {
                                if (profiles[i] instanceof Profile) {
                                    URI localProfileURI = ((Profile)profiles[i]).eResource().getURI();
                                    IPath filePath = file.getFullPath();
                                    URI modelURI = umlResource.getURI();
                                    URI relativeProfileURI = localProfileURI.deresolve(modelURI);
                                    String installedProfileURI = EditProfileApplicationAction.findCorrespondingInstalledProfile((Profile)profiles[i]);
                                    if (installedProfileURI != null) {
                                        try {
                                            WSFileUtil.replaceString(localProfileURI.toString(), installedProfileURI, adapter, doc, 0, multiEdit);
                                            WSFileUtil.replaceString(relativeProfileURI.toString(), installedProfileURI, adapter, doc, 0, multiEdit);
                                        }
                                        catch (BadLocationException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (multiEdit.hasChildren()) {
                                try {
                                    multiEdit.apply(doc);
                                }
                                catch (MalformedTreeException e) {
                                    e.printStackTrace();
                                }
                                catch (BadLocationException e) {
                                    e.printStackTrace();
                                }
                                try {
                                    buffer.commit(null, true);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
                    }
                    catch (InvocationTargetException e) {
                        Status status = new Status(4, "org.eclipse.papyrus.uml.export", e.getMessage(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                    catch (InterruptedException e) {
                        Status status = new Status(4, "org.eclipse.papyrus.uml.export", e.getMessage(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
            } else {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"No profile application to edit");
            }
        }
    }

    public static String findCorrespondingInstalledProfile(Profile profile) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.uml.export");
        Preferences node = preferences.node("installedProfilesUriCorrespondance");
        String installedProfileURI = node.get(profile.eResource().getURI().toString(), "default");
        if (!installedProfileURI.equals("default")) {
            URI uri = URI.createURI((String)installedProfileURI);
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(uri, true);
                if (resource.isLoaded() && !resource.getContents().isEmpty()) {
                    return installedProfileURI;
                }
            }
            catch (WrappedException ex) {
                ex.printStackTrace();
            }
        } else {
            return null;
        }
        return null;
    }
}

