/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class WSFileUtil {
    public static String getFileName(EObject model, String extension) throws ServiceException {
        Resource resource = model.eResource();
        String resourcepath = resource.getURI().toString();
        String umlFileName = resourcepath.substring(resourcepath.lastIndexOf("/") + 1, resourcepath.length());
        return umlFileName;
    }

    public static Resource loadResource(String path, ResourceSet resourceSet) {
        URI uri = URI.createPlatformResourceURI((String)path);
        try {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource.isLoaded()) {
                return resource;
            }
        }
        catch (WrappedException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void replaceString(String oldString, String newString, FindReplaceDocumentAdapter adapter, IDocument doc, int offset, MultiTextEdit multiEdit) throws BadLocationException {
        IRegion region = adapter.find(offset, oldString, true, true, false, true);
        if (region != null) {
            multiEdit.addChild((TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), newString));
            WSFileUtil.replaceString(oldString, newString, adapter, doc, region.getOffset() + region.getLength(), multiEdit);
        }
    }

    public static void copy(InputStream source, File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = source.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            source.close();
            ((OutputStream)out).close();
        }
    }

    public static void copyFile(IProject project, File iconSrc, String destinationDir, String destFileName) {
        File targetIconFile = FileUtil.getWorkspaceFile((String)("/" + project.getName() + "/" + destinationDir + "/" + destFileName));
        if (!targetIconFile.getParentFile().exists()) {
            targetIconFile.getParentFile().mkdirs();
        }
        try {
            WSFileUtil.copy(new FileInputStream(iconSrc), targetIconFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

