/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.properties.modelelement;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageKind;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageSet;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTExtModelElement
extends UMLModelElement {
    private Hashtable<Element, UMLModelElement> delegationModelElements = new Hashtable();
    private final String ownedOp = "ownedOperation";

    public UMLRTExtModelElement(EObject source) {
        super(source, (EditingDomain)TransactionUtil.getEditingDomain((EObject)source));
    }

    public UMLModelElement getDelegationModelElement(Element element) {
        UMLModelElement delegationModelElement = this.delegationModelElements.get(element);
        if (delegationModelElement == null) {
            delegationModelElement = new UMLModelElement((EObject)element, this.getDomain());
            this.delegationModelElements.put(element, delegationModelElement);
        }
        return delegationModelElement;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getContentProvider("ownedOperation");
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isOrdered(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).isOrdered("ownedOperation");
        }
        return super.isOrdered(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).isMandatory("ownedOperation");
        }
        return super.isMandatory(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getLabelProvider("ownedOperation");
        }
        return super.getLabelProvider(propertyPath);
    }

    public EStructuralFeature getFeature(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getFeature("ownedOperation");
        }
        return super.getFeature(propertyPath);
    }

    public FeaturePath getFeaturePath(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getFeaturePath("ownedOperation");
        }
        return super.getFeaturePath(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).doGetObservable("ownedOperation");
        }
        return super.doGetObservable(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        Interface intf = this.getProvidedOrRequiredInterface(propertyPath);
        if (intf != null) {
            return this.getDelegationModelElement((Element)intf).getValueFactory("ownedOperation");
        }
        return super.getValueFactory(propertyPath);
    }

    protected Interface getProvidedOrRequiredInterface(String propertyPath) {
        Interface result = null;
        if (this.source instanceof Collaboration) {
            if (propertyPath.endsWith("Incoming")) {
                result = this.getInterface(RTMessageKind.IN);
            } else if (propertyPath.endsWith("Outgoing")) {
                result = this.getInterface(RTMessageKind.OUT);
            } else if (propertyPath.endsWith("InOut")) {
                result = this.getInterface(RTMessageKind.IN_OUT);
            }
        }
        return result;
    }

    protected Interface getInterface(RTMessageKind rtMessageKind) {
        Interface result = null;
        Collaboration protocol = (Collaboration)this.source;
        Iterator relationshipIterator = protocol.getSourceDirectedRelationships().iterator();
        while (relationshipIterator.hasNext() && result == null) {
            DirectedRelationship directedRelation = (DirectedRelationship)relationshipIterator.next();
            if (!(directedRelation instanceof Dependency)) continue;
            Dependency dependency = (Dependency)directedRelation;
            Iterator dependencyIterator = dependency.getSuppliers().iterator();
            while (dependencyIterator.hasNext() && result == null) {
                Interface interfaceImpl;
                RTMessageSet rtMessageSet;
                NamedElement supplier = (NamedElement)dependencyIterator.next();
                if (!(supplier instanceof Interface) || (rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)(interfaceImpl = (Interface)supplier), RTMessageSet.class)) == null || rtMessageSet.getRtMsgKind() != rtMessageKind) continue;
                result = (Interface)supplier;
            }
        }
        return result;
    }
}

