/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.UMLRealTime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RTMessageKind implements Enumerator
{
    IN(0, "in", "in"),
    OUT(1, "out", "out"),
    IN_OUT(2, "inOut", "inOut");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int IN_OUT_VALUE = 2;
    private static final RTMessageKind[] VALUES_ARRAY;
    public static final List<RTMessageKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RTMessageKind[]{IN, OUT, IN_OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RTMessageKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RTMessageKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RTMessageKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RTMessageKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RTMessageKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return IN_OUT;
            }
        }
        return null;
    }

    private RTMessageKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

