/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.internal.sync.statemachine;

import com.google.common.base.Predicate;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.SyncRegistry;
import org.eclipse.papyrus.umlrt.internal.sync.UMLSyncFeature;
import org.eclipse.papyrus.umlrt.internal.sync.statemachine.TransitionSyncBucket;
import org.eclipse.papyrus.umlrt.internal.sync.statemachine.TransitionSyncRegistry;
import org.eclipse.papyrus.umlrt.internal.sync.statemachine.VertexSyncRegistry;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class RegionTransitionsSyncFeature
extends UMLSyncFeature<Region, Transition> {
    public RegionTransitionsSyncFeature(SyncBucket<Region, EObject, Notification> bucket) {
        super(bucket, UMLPackage.Literals.REGION__TRANSITION, new EReference[0]);
    }

    @Override
    protected Class<? extends SyncRegistry<Transition, EObject, Notification>> getNestedRegistryType() {
        return TransitionSyncRegistry.class;
    }

    protected Command onTargetAdded(SyncItem<Region, EObject> from, EObject source, SyncItem<Region, EObject> to, EObject target) {
        Command result = null;
        Transition transition = (Transition)target;
        Transition superTransition = (Transition)source;
        result = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)transition, (Object)UMLPackage.Literals.TRANSITION__REDEFINED_TRANSITION, (Object)source);
        result = result.chain(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)transition, (Object)UMLPackage.Literals.TRANSITION__SOURCE, (Object)this.findRedefiningVertex(transition.getContainer(), superTransition.getSource())));
        result = result.chain(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)transition, (Object)UMLPackage.Literals.TRANSITION__TARGET, (Object)this.findRedefiningVertex(transition.getContainer(), superTransition.getTarget())));
        SyncRegistry registry = this.getNestedRegistry();
        if (registry != null) {
            Object bucket = registry.getBucket((Object)superTransition);
            if (bucket == null) {
                bucket = new TransitionSyncBucket(superTransition);
                registry.register(bucket);
            }
            result = this.synchronizingWrapper(registry, transition, result);
        }
        return result;
    }

    protected Command onTargetRemoved(SyncItem<Region, EObject> to, EObject target) {
        return null;
    }

    protected Vertex findRedefiningVertex(Region context, Vertex superVertex) {
        Vertex result = null;
        final StateMachine stateMachine = context.getStateMachine();
        VertexSyncRegistry registry = (VertexSyncRegistry)this.getSyncRegistry(VertexSyncRegistry.class);
        SyncBucket bucket = registry.getBucket(superVertex);
        if (bucket != null) {
            result = (Vertex)bucket.findBackend((Predicate)new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    Vertex vertex = (Vertex)input;
                    return vertex.getContainer().containingStateMachine() == stateMachine;
                }
            });
        }
        return result;
    }
}

