/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.panels;

import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrus.C_Cpp.Virtual;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.views.cpp.CommandSupport;
import org.eclipse.papyrus.views.panels.CppAbstractPanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;

@Deprecated
public class CppBehaviorPanel
extends CppAbstractPanel {
    private Group groupBody;
    private IDocument docBody;
    private Behavior selectedBehavior;
    Element selectedEOwner;
    protected String origBody;

    public CppBehaviorPanel(Composite parent, int style) {
        super(parent, style);
    }

    public Behavior getSelectedElement() {
        return this.selectedBehavior;
    }

    @Override
    public void setSelectedElement(Element newElement) {
        super.setSelectedElement(newElement);
        if (!(newElement instanceof Behavior)) {
            throw new RuntimeException("bad selection: " + newElement + " should be an uml2 Behavior");
        }
        this.selectedBehavior = (Behavior)newElement;
        this.selectedEOwner = this.selectedBehavior.getOwner();
    }

    @Override
    public Control createContent() {
        this.createSaveResetButtons();
        this.docBody = this.createDocumentC();
        this.groupBody = this.createGroup(this, "Method body", (Control)this.buttonSave, null, true, 0, 0, true);
        this.createViewerC(this.docBody, this.groupBody);
        return this;
    }

    @Override
    public void save() {
        if (this.selectedBehavior != null) {
            CommandSupport.exec("C++ behavior save", new Runnable(){

                @Override
                public void run() {
                    CppBehaviorPanel.setCppBody(CppBehaviorPanel.this.selectedBehavior, CppBehaviorPanel.this.docBody.get());
                    CppBehaviorPanel.this.origBody = CppBehaviorPanel.this.docBody.get();
                }
            });
        }
    }

    public static String getCppBody(Behavior behavior) {
        if (behavior instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            int i = 0;
            for (String language : ob.getLanguages()) {
                if (language.equals("C/C++")) {
                    return (String)ob.getBodies().get(i);
                }
                if (language.equals("C++")) {
                    return (String)ob.getBodies().get(i);
                }
                if (language.equals("C")) {
                    return (String)ob.getBodies().get(i);
                }
                ++i;
            }
        }
        return "";
    }

    public static void setCppBody(Behavior behavior, String body) {
        boolean done = false;
        if (behavior instanceof OpaqueBehavior) {
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            int i = 0;
            for (String language : ob.getLanguages()) {
                if (language.equals("C/C++") || language.equals("C++") || language.equals("C")) {
                    done = true;
                    ob.getBodies().set(i, (Object)body);
                    break;
                }
                ++i;
            }
            if (!done) {
                ob.getLanguages().add((Object)"C/C++");
                ob.getBodies().add((Object)body);
            }
        }
    }

    @Override
    public void entryAction() {
        super.entryAction();
        this.reset();
    }

    @Override
    public void exitAction() {
        if (this.selectedEOwner instanceof Class) {
            super.exitAction();
        }
    }

    @Override
    public boolean checkModifications() {
        return !this.docBody.get().equals(this.origBody);
    }

    @Override
    protected void refreshPanel() {
        if (this.selectedBehavior != null) {
            String body;
            this.origBody = body = CppBehaviorPanel.getCppBody(this.selectedBehavior);
            this.docBody.set(body);
        }
    }

    @Override
    protected boolean isModelValid() {
        if (this.selectedBehavior == null) {
            return true;
        }
        if (this.selectedEOwner instanceof Class) {
            if (this.selectedBehavior.isAbstract() && !StereotypeUtil.isApplied((Element)this.selectedBehavior, Virtual.class)) {
                return false;
            }
        } else {
            if (!this.selectedBehavior.isAbstract()) {
                return false;
            }
            if (StereotypeUtil.isApplied((Element)this.selectedBehavior, Virtual.class)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void updateModel() {
        CommandSupport.exec("C++ behavior save", new Runnable(){

            @Override
            public void run() {
                if (CppBehaviorPanel.this.selectedBehavior == null) {
                    return;
                }
                if (!(CppBehaviorPanel.this.selectedEOwner instanceof Class)) {
                    CppBehaviorPanel.this.selectedBehavior.setIsAbstract(true);
                }
            }
        });
    }
}

