/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.tracepoints.views;

import java.util.Map;
import javax.swing.text.View;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.tracepoints.MarkerUtils;
import org.eclipse.papyrus.infra.services.tracepoints.TraceFunctions;
import org.eclipse.papyrus.infra.services.tracepoints.TraceState;
import org.eclipse.papyrus.infra.services.tracepoints.dialogs.TraceActionSelection;
import org.eclipse.papyrus.views.tracepoints.views.TraceViewImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class TracepointView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.papyrus.views.tracepoints.views.Tracepoints";
    private CheckboxTableViewer viewer;
    protected Action actionDelete;
    protected Action actionDeleteAll;
    protected Action actionGoto;
    protected Action actionSkip;
    protected Action actionTraceSelect;
    private Action doubleClickAction;
    private IFileObserver fileObserver = null;
    protected TraceActionSelection tas;
    protected Element currentElement;

    public void createPartControl(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof IMarker) {
                    IMarker marker = (IMarker)element;
                    return marker.getAttribute("isActive", false);
                }
                return false;
            }
        });
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.papyrus.views.tracepoints.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean isChecked = event.getChecked();
                if (element instanceof IMarker) {
                    IMarker marker = (IMarker)element;
                    try {
                        marker.setAttribute("isActive", isChecked);
                        TracepointView.this.switchUI();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        });
        this.fileObserver = new IFileObserver(){

            public void handleMarkerDeleted(IMarker marker, Map attributes) {
                TracepointView.this.switchUI();
            }

            public void handleMarkerChanged(IMarker marker) {
                TracepointView.this.switchUI();
            }

            public void handleMarkerAdded(IMarker marker) {
                TracepointView.this.switchUI();
            }

            public void handleFileRenamed(IFile oldFile, IFile file) {
            }

            public void handleFileMoved(IFile oldFile, IFile file) {
            }

            public void handleFileDeleted(IFile file) {
            }

            public void handleFileChanged(IFile file) {
            }
        };
        FileChangeManager.getInstance().addFileObserver(this.fileObserver);
    }

    public void dispose() {
        if (this.fileObserver != null) {
            FileChangeManager.getInstance().addFileObserver(this.fileObserver);
        }
        super.dispose();
    }

    public void switchUI() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TracepointView.this.viewer.refresh();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TracepointView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionGoto);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionGoto);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionDeleteAll);
        manager.add((IAction)this.actionGoto);
        manager.add((IAction)this.actionSkip);
        manager.add((IAction)this.actionTraceSelect);
    }

    protected void makeActions() {
        this.actionSkip = new Action("Skip all", 2){

            public void run() {
                TraceState.skipAllTracepoints = !TraceState.skipAllTracepoints;
                TracepointView.this.switchUI();
            }
        };
        this.actionSkip.setChecked(TraceState.skipAllTracepoints);
        this.actionSkip.setImageDescriptor(TraceViewImages.getSkipAllID());
        this.actionSkip.setToolTipText("Toggle skipping all trace/break points");
        this.actionDelete = new Action("Delete"){

            public void run() {
                ISelection selection = TracepointView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IMarker) {
                    IMarker marker = (IMarker)obj;
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        };
        this.actionDelete.setToolTipText("Delete trace/breakpoint");
        this.actionDelete.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.actionDeleteAll = new Action(){

            public void run() {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (root != null) {
                    try {
                        root.deleteMarkers("org.eclipse.papyrus.tporbpmarker", true, 0);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        };
        this.actionDeleteAll.setText("Delete all");
        this.actionDeleteAll.setToolTipText("Delete all trace/breakpoint");
        this.actionDeleteAll.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL"));
        this.actionGoto = new Action(){

            public void run() {
                ISelection selection = TracepointView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IMarker) {
                    IMarker marker = (IMarker)obj;
                    boolean onlyNavigatoToActiveEditor = false;
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (onlyNavigatoToActiveEditor) {
                        IEditorPart part = activePage.getActiveEditor();
                        if (part instanceof IGotoMarker) {
                            ((IGotoMarker)part).gotoMarker(marker);
                        }
                    } else {
                        try {
                            IDE.openEditor((IWorkbenchPage)activePage, (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.actionGoto.setText("Goto");
        this.actionGoto.setToolTipText("Navigate to trace/breakpoint");
        this.actionGoto.setImageDescriptor(TraceViewImages.getGotoObjID());
        this.doubleClickAction = this.actionGoto;
        this.actionTraceSelect = new Action(){

            public void run() {
                IMarker marker;
                EObject eobj;
                ISelection selection = TracepointView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IMarker && (eobj = MarkerUtils.getEObjectOfMarker((IMarker)(marker = (IMarker)obj))) instanceof Element) {
                    TraceActionSelection tad = new TraceActionSelection(Display.getDefault().getActiveShell(), (IMarker)obj, (Element)eobj);
                    tad.open();
                    if (tad.getReturnCode() == 0) {
                        Object[] result = tad.getResult();
                        int traceAction = (Integer)result[0];
                        String traceMechanism = (String)result[1];
                        try {
                            marker.setAttribute("traceAction", traceAction);
                            marker.setAttribute("traceMechanism", (Object)traceMechanism);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.actionTraceSelect.setText("trace action");
        this.actionTraceSelect.setToolTipText("Select trace action");
        this.actionTraceSelect.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
    }

    protected void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TracepointView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection sSelection = null;
        if (selection instanceof IStructuredSelection) {
            sSelection = (IStructuredSelection)selection;
        }
        if (selection != null && sSelection != null && sSelection.isEmpty()) {
            return;
        }
        this.currentElement = null;
        if (sSelection == null || sSelection.size() != 1) {
            this.switchUI();
            return;
        }
        Object currentObject = sSelection.getFirstElement();
        if (currentObject instanceof GraphicalEditPart) {
            View view;
            GraphicalEditPart editPart = (GraphicalEditPart)currentObject;
            if (editPart.getModel() instanceof View && (view = (View)editPart.getModel()).getElement() instanceof Element) {
                currentObject = view.getElement();
            }
        } else if (currentObject instanceof IAdaptable) {
            currentObject = ((IAdaptable)currentObject).getAdapter(EObject.class);
        }
        if (currentObject instanceof Element) {
            this.currentElement = (Element)currentObject;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (root != null) {
                    return root.findMarkers("org.eclipse.papyrus.tporbpmarker", true, 2);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return new String[0];
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TraceFunctions traceImage = new TraceFunctions();

        public String getColumnText(Object obj, int index) {
            if (obj instanceof IMarker) {
                EObject eobj = MarkerUtils.getEObjectOfMarker((IMarker)((IMarker)obj));
                if (eobj instanceof NamedElement) {
                    return ((NamedElement)eobj).getQualifiedName();
                }
                if (eobj != null) {
                    return eobj.toString();
                }
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            IPapyrusMarker marker;
            ImageDescriptor id;
            if (TraceState.skipAllTracepoints) {
                return TraceViewImages.getSkipAllImage();
            }
            if (obj instanceof IPapyrusMarker && (id = this.traceImage.getImageDescriptorForGE(marker = (IPapyrusMarker)obj)) != null) {
                return id.createImage();
            }
            return null;
        }
    }
}

