/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ProrXhtmlSimplifiedHelper;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.common.util.ReqIFToolExtensionUtil;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.LabelConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrGeneralConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfigurations;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrToolExtension;
import org.eclipse.rmf.reqif10.pror.util.PresentationEditInterface;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.util.ReqIF10Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtil {
    public static final String DEFAULT_LEFT_HEADER_COLUMN_NAME = "Lead Header Column";
    public static final int DEFAULT_LEFT_HEADER_COLUMN_WIDTH = 30;

    public static ProrPresentationConfiguration getPresentationConfiguration(DatatypeDefinition dd) {
        ReqIF reqif = ReqIF10Util.getReqIF((Object)dd);
        if (reqif == null) {
            return null;
        }
        ProrToolExtension prorToolExtension = ConfigurationUtil.getProrToolExtension(reqif);
        if (prorToolExtension == null) {
            return null;
        }
        ProrPresentationConfigurations extensions = prorToolExtension.getPresentationConfigurations();
        if (extensions == null) {
            return null;
        }
        for (ProrPresentationConfiguration config : extensions.getPresentationConfigurations()) {
            if (!dd.equals(config.getDatatype())) continue;
            return config;
        }
        return null;
    }

    public static ProrPresentationConfiguration getPresentationConfiguration(AttributeValue av) {
        DatatypeDefinition dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)av);
        if (av != null) {
            return ConfigurationUtil.getPresentationConfiguration(dd);
        }
        return null;
    }

    public static ProrToolExtension getProrToolExtension(ReqIF reqif) {
        List extensions;
        if (reqif != null && (extensions = ReqIFToolExtensionUtil.getToolExtensionsByType((ReqIF)reqif, (EClassifier)ConfigurationPackage.eINSTANCE.getProrToolExtension())).size() > 0) {
            return (ProrToolExtension)extensions.get(0);
        }
        return null;
    }

    public static ProrToolExtension createProrToolExtension(ReqIF reqif, EditingDomain domain) {
        ProrToolExtension extension = ConfigurationUtil.getProrToolExtension(reqif);
        if (extension == null) {
            extension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
            domain.getCommandStack().execute(ReqIFToolExtensionUtil.getAddToolExtensionCommand((ReqIF)reqif, (EObject)extension));
        }
        return extension;
    }

    public static Column getLeftHeaderColumn(Specification specification, EditingDomain domain) {
        ProrSpecViewConfiguration specViewConfiguration = ConfigurationUtil.createSpecViewConfiguration(specification, domain);
        Column leftHeaderColumn = specViewConfiguration.getLeftHeaderColumn();
        if (leftHeaderColumn == null) {
            leftHeaderColumn = ConfigurationFactory.eINSTANCE.createColumn();
            leftHeaderColumn.setLabel(DEFAULT_LEFT_HEADER_COLUMN_NAME);
            leftHeaderColumn.setWidth(30);
            specViewConfiguration.setLeftHeaderColumn(leftHeaderColumn);
        }
        return leftHeaderColumn;
    }

    public static Set<PresentationEditInterface> getPresentationEditInterfaces(Object obj, AdapterFactory adapterFactory) {
        ReqIF reqif = ReqIF10Util.getReqIF((Object)obj);
        ProrPresentationConfigurations configs = ConfigurationUtil.getPresentationConfigurations(reqif);
        if (configs != null) {
            HashSet<PresentationEditInterface> result = new HashSet<PresentationEditInterface>();
            for (ProrPresentationConfiguration config : configs.getPresentationConfigurations()) {
                ItemProviderAdapter ip = ProrUtil.getItemProvider(adapterFactory, config);
                if (!(ip instanceof PresentationEditInterface)) continue;
                result.add((PresentationEditInterface)ip);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static String getSpecElementLabel(SpecElementWithAttributes specElement, AdapterFactory adapterFactory) {
        List<String> labels = ConfigurationUtil.getDefaultLabels(ReqIF10Util.getReqIF((Object)specElement));
        for (String label : labels) {
            for (AttributeValue value : specElement.getValues()) {
                String customLabel;
                AttributeDefinition ad = ReqIF10Util.getAttributeDefinition((AttributeValue)value);
                if (ad == null || !label.equals(ad.getLongName())) continue;
                ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfig(value);
                ItemProviderAdapter ip = ProrUtil.getItemProvider(adapterFactory, config);
                if (ip instanceof PresentationEditInterface && (customLabel = ((PresentationEditInterface)ip).getLabel(value)) != null) {
                    return customLabel;
                }
                Object result = ReqIF10Util.getTheValue((AttributeValue)value);
                if (result == null) continue;
                if (value instanceof AttributeValueEnumeration && result instanceof EList) {
                    EList list = (EList)result;
                    if (!list.isEmpty()) {
                        return ((EnumValue)list.get(0)).getLongName();
                    }
                    return "";
                }
                if (value instanceof AttributeValueXHTML && result instanceof XhtmlContent) {
                    XhtmlContent content = (XhtmlContent)result;
                    String text = ProrXhtmlSimplifiedHelper.xhtmlToSimplifiedString((XhtmlContent)content);
                    if (text.trim().length() == 0) continue;
                    if (text.length() > 20) {
                        text = String.valueOf(text.substring(0, 17)) + "...";
                    }
                    return text;
                }
                return result.toString();
            }
        }
        return specElement.getIdentifier();
    }

    public static List<String> getDefaultLabels(ReqIF reqif) {
        ProrToolExtension extension = ConfigurationUtil.getProrToolExtension(reqif);
        if (extension == null) {
            return Collections.emptyList();
        }
        ProrGeneralConfiguration generalConfig = extension.getGeneralConfiguration();
        if (generalConfig == null) {
            return Collections.emptyList();
        }
        LabelConfiguration labelConfig = generalConfig.getLabelConfiguration();
        if (labelConfig == null) {
            return Collections.emptyList();
        }
        return labelConfig.getDefaultLabel();
    }

    public static ProrSpecViewConfiguration createSpecViewConfiguration(Specification specification, EditingDomain domain) {
        ProrToolExtension extension = ConfigurationUtil.createProrToolExtension(ReqIF10Util.getReqIF((Object)specification), domain);
        EList configs = extension.getSpecViewConfigurations();
        for (ProrSpecViewConfiguration config : configs) {
            if (config.getSpecification() == null || !config.getSpecification().equals(specification)) continue;
            return config;
        }
        ProrSpecViewConfiguration specViewConfig = ConfigurationFactory.eINSTANCE.createProrSpecViewConfiguration();
        specViewConfig.setSpecification(specification);
        final ArrayList types = new ArrayList();
        ReqIF10Switch<SpecHierarchy> visitor = new ReqIF10Switch<SpecHierarchy>(){

            public SpecHierarchy caseSpecHierarchy(SpecHierarchy specHierarchy) {
                SpecObjectType type;
                if (specHierarchy.getObject() != null && (type = specHierarchy.getObject().getType()) != null && !types.contains(type)) {
                    types.add(type);
                }
                return specHierarchy;
            }
        };
        int counter = 0;
        TreeIterator i = EcoreUtil.getAllContents((EObject)specification, (boolean)true);
        while (i.hasNext()) {
            visitor.doSwitch((EObject)i.next());
            if (counter++ == 50) break;
        }
        ArrayList<String> colNames = new ArrayList<String>();
        for (SpecType type : types) {
            for (AttributeDefinition ad : type.getSpecAttributes()) {
                String colName = ad.getLongName();
                if (colName == null || colNames.contains(colName)) continue;
                colNames.add(ad.getLongName());
            }
        }
        boolean unifiedColumn = false;
        for (String colName : colNames) {
            Column column = ConfigurationFactory.eINSTANCE.createColumn();
            if (colName.equals("ReqIF.Text") || colName.equals("ReqIF.ChapterName")) {
                if (unifiedColumn) continue;
                column = ConfigurationFactory.eINSTANCE.createUnifiedColumn();
                colName = "Main";
                unifiedColumn = true;
            }
            column.setWidth(100);
            column.setLabel(colName);
            specViewConfig.getColumns().add((Object)column);
        }
        domain.getCommandStack().execute(AddCommand.create((EditingDomain)domain, (Object)extension, (Object)ConfigurationPackage.Literals.PROR_TOOL_EXTENSION__SPEC_VIEW_CONFIGURATIONS, (Object)specViewConfig));
        return specViewConfig;
    }

    public static ProrPresentationConfiguration getPresentationConfig(AttributeValue value) {
        DatatypeDefinition dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)value);
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration(dd);
        return config;
    }

    public static ProrPresentationConfigurations getPresentationConfigurations(ReqIF reqif) {
        ProrToolExtension uiExtension = ConfigurationUtil.getProrToolExtension(reqif);
        return uiExtension == null ? null : uiExtension.getPresentationConfigurations();
    }

    public static void setDefaultLabelsIfNecessary(AdapterFactory adapterFactory, EditingDomain editingDomain, ReqIF reqif) {
        LabelConfiguration labelConfig;
        CompoundCommand cmd = new CompoundCommand();
        ProrToolExtension extension = ConfigurationUtil.createProrToolExtension(reqif, editingDomain);
        ProrGeneralConfiguration generalConfig = extension.getGeneralConfiguration();
        if (generalConfig == null) {
            generalConfig = ConfigurationFactory.eINSTANCE.createProrGeneralConfiguration();
            cmd.append(SetCommand.create((EditingDomain)editingDomain, (Object)extension, (Object)ConfigurationPackage.Literals.PROR_TOOL_EXTENSION__GENERAL_CONFIGURATION, (Object)generalConfig));
        }
        if ((labelConfig = generalConfig.getLabelConfiguration()) != null) {
            return;
        }
        labelConfig = ConfigurationFactory.eINSTANCE.createLabelConfiguration();
        cmd.append(SetCommand.create((EditingDomain)editingDomain, (Object)generalConfig, (Object)ConfigurationPackage.Literals.PROR_GENERAL_CONFIGURATION__LABEL_CONFIGURATION, (Object)labelConfig));
        labelConfig.getDefaultLabel().add((Object)"ReqIF.ChapterNumber");
        labelConfig.getDefaultLabel().add((Object)"ReqIF.ChapterName");
        labelConfig.getDefaultLabel().add((Object)"ReqIF.Name");
        labelConfig.getDefaultLabel().add((Object)"ReqIF.Text");
        labelConfig.getDefaultLabel().add((Object)"ID");
        labelConfig.getDefaultLabel().add((Object)"Name");
        labelConfig.getDefaultLabel().add((Object)"Description");
        editingDomain.getCommandStack().execute((Command)cmd);
    }
}

