/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.modelelement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.customization.properties.modelelement.SectionNameObservableValue;
import org.eclipse.papyrus.customization.properties.providers.ConstraintDescriptorContentProvider;
import org.eclipse.papyrus.customization.properties.providers.ContextLabelProvider;
import org.eclipse.papyrus.customization.properties.providers.DataContextElementContentProvider;
import org.eclipse.papyrus.customization.properties.providers.DependencyContentProvider;
import org.eclipse.papyrus.customization.properties.providers.EnvironmentContentProvider;
import org.eclipse.papyrus.customization.properties.providers.PropertyContentProvider;
import org.eclipse.papyrus.customization.properties.providers.PropertyEditorTypeContentProvider;
import org.eclipse.papyrus.customization.properties.providers.TabContentProvider;
import org.eclipse.papyrus.infra.constraints.ConstraintsPackage;
import org.eclipse.papyrus.infra.constraints.environment.EnvironmentPackage;
import org.eclipse.papyrus.infra.constraints.providers.ConstraintTypeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.IStrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.ui.PropertyEditor;

public class CustomizationModelElement
extends AbstractModelElement {
    protected EMFModelElement delegate;
    private static Map<EClassifier, IStaticContentProvider> providers;

    public CustomizationModelElement(EMFModelElement delegate) {
        this.delegate = delegate;
        if (providers == null) {
            CustomizationModelElement.initializeProviders();
        }
    }

    private static void initializeProviders() {
        providers = new HashMap<EClassifier, IStaticContentProvider>();
        providers.put((EClassifier)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getCompositeWidgetType(), new EnvironmentContentProvider((EStructuralFeature)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getEnvironment_CompositeWidgetTypes()));
        providers.put((EClassifier)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getStandardWidgetType(), new EnvironmentContentProvider((EStructuralFeature)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getEnvironment_WidgetTypes()));
        providers.put((EClassifier)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getLayoutType(), new EnvironmentContentProvider((EStructuralFeature)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getEnvironment_LayoutTypes()));
        providers.put((EClassifier)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getModelElementFactoryDescriptor(), new EnvironmentContentProvider((EStructuralFeature)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getEnvironment_ModelElementFactories()));
        providers.put((EClassifier)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getPropertyEditorType(), new EnvironmentContentProvider((EStructuralFeature)org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getEnvironment_PropertyEditorTypes()));
        providers.put((EClassifier)EnvironmentPackage.eINSTANCE.getConstraintType(), (IStaticContentProvider)new ConstraintTypeContentProvider());
    }

    public IObservable doGetObservable(String propertyPath) {
        EStructuralFeature feature = this.delegate.getFeature(propertyPath);
        if (ContextsPackage.eINSTANCE.getSection_Name() == feature) {
            return new SectionNameObservableValue(this.delegate.getSource(), feature, this.delegate.getDomain());
        }
        return this.delegate.getObservable(propertyPath);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        EStructuralFeature feature = this.delegate.getFeature(propertyPath);
        if (feature == null) {
            return EmptyContentProvider.instance;
        }
        IStaticContentProvider provider = this.findProvider(feature);
        if (provider == null) {
            return this.delegate.getContentProvider(propertyPath);
        }
        if (provider instanceof ITreeContentProvider) {
            IStrategyBasedContentProvider strategyProvider = this.getStrategyProvider((ITreeContentProvider)provider);
            if (feature.getEType() == org.eclipse.papyrus.views.properties.environment.EnvironmentPackage.eINSTANCE.getPropertyEditorType()) {
                return new PropertyEditorTypeContentProvider((IStructuredContentProvider)strategyProvider, (PropertyEditor)this.delegate.getSource());
            }
            return new EMFGraphicalContentProvider((IStructuredContentProvider)strategyProvider, ConfigurationManager.getInstance().getResourceSet(), "history_" + feature.getName());
        }
        return provider;
    }

    protected IStrategyBasedContentProvider getStrategyProvider(ITreeContentProvider provider) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        ContainmentBrowseStrategy revealStrategy = new ContainmentBrowseStrategy(provider);
        return new StrategyBasedContentProvider((TreeBrowseStrategy)browseStrategy, (TreeBrowseStrategy)revealStrategy);
    }

    protected IStaticContentProvider findProvider(EStructuralFeature feature) {
        EClassifier classifier = feature.getEType();
        if (providers.containsKey(classifier)) {
            return providers.get(classifier);
        }
        if (classifier == ContextsPackage.eINSTANCE.getProperty()) {
            return new PropertyContentProvider(this.delegate.getSource());
        }
        if (classifier == ContextsPackage.eINSTANCE.getTab()) {
            boolean editableTabsOnly = this.delegate.getSource() instanceof Section;
            return new TabContentProvider(this.delegate.getSource(), editableTabsOnly);
        }
        if (classifier instanceof EClass && EMFHelper.isSubclass((EClass)((EClass)classifier), (EClass)ConstraintsPackage.eINSTANCE.getConstraintDescriptor())) {
            return new ConstraintDescriptorContentProvider(this.delegate.getSource(), (EClass)classifier);
        }
        if (this.isDataContextElement(classifier)) {
            return new DataContextElementContentProvider((DataContextElement)this.delegate.getSource());
        }
        if (classifier == ContextsPackage.eINSTANCE.getContext()) {
            return new DependencyContentProvider((Context)this.delegate.getSource());
        }
        return null;
    }

    private boolean isDataContextElement(EClassifier classifier) {
        if (classifier == ContextsPackage.eINSTANCE.getDataContextElement()) {
            return true;
        }
        if (classifier instanceof EClass) {
            EClass eClass = (EClass)classifier;
            return eClass.getEAllSuperTypes().contains((Object)ContextsPackage.eINSTANCE.getDataContextElement());
        }
        return false;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        return new ContextLabelProvider();
    }

    public boolean isOrdered(String propertyPath) {
        return this.delegate.isOrdered(propertyPath);
    }

    public boolean isUnique(String propertyPath) {
        return this.delegate.isUnique(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        return this.delegate.isMandatory(propertyPath);
    }

    public boolean isEditable(String propertyPath) {
        if (this.delegate.getFeature(propertyPath) == ContextsPackage.eINSTANCE.getSection_SectionFile()) {
            return false;
        }
        return this.delegate.isEditable(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        return this.delegate.getValueFactory(propertyPath);
    }

    public boolean getDirectCreation(String propertyPath) {
        return this.delegate.getDirectCreation(propertyPath);
    }

    public boolean forceRefresh(String localPropertyPath) {
        return false;
    }

    public Object getDefaultValue(String propertyPath) {
        return this.delegate.getDefaultValue(propertyPath);
    }

    public void setDataSource(DataSource source) {
        this.delegate.setDataSource(source);
    }

    public void dispose() {
        super.dispose();
        this.delegate.dispose();
    }
}

