/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.providers;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.widgets.providers.AbstractFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.views.properties.contexts.DataContextRoot;

public class DataContextElementContentProvider
extends AbstractFilteredContentProvider
implements IStaticContentProvider {
    private List<DataContextElement> elements;

    public DataContextElementContentProvider(DataContextElement element) {
        Context context = this.findContext(element);
        HashSet<Context> allContexts = new HashSet<Context>();
        if (context != null) {
            this.getAllContexts(context, allContexts);
        }
        HashSet<DataContextElement> allElements = new HashSet<DataContextElement>();
        for (Context ctx : allContexts) {
            for (DataContextRoot root : ctx.getDataContexts()) {
                this.getAllElements((DataContextElement)root, allElements);
            }
        }
        this.elements = new LinkedList<DataContextElement>(allElements);
        Collections.sort(this.elements, new Comparator<DataContextElement>(){
            private Collator collator = RuleBasedCollator.getInstance();

            @Override
            public int compare(DataContextElement element1, DataContextElement element2) {
                String name1 = element1.getName();
                String name2 = element2.getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return this.collator.compare(name1, name2);
            }
        });
        this.showIfHasVisibleParent = true;
    }

    private void getAllElements(DataContextElement fromElement, Collection<DataContextElement> result) {
        if (result.contains(fromElement)) {
            return;
        }
        result.add(fromElement);
        if (fromElement instanceof DataContextPackage) {
            DataContextPackage fromPackage = (DataContextPackage)fromElement;
            for (DataContextElement element : fromPackage.getElements()) {
                this.getAllElements(element, result);
            }
        }
    }

    private void getAllContexts(Context fromContext, Collection<Context> result) {
        if (result.contains(fromContext)) {
            return;
        }
        result.add(fromContext);
        for (Context context : fromContext.getDependencies()) {
            this.getAllContexts(context, result);
        }
    }

    private Context findContext(DataContextElement element) {
        if (element.getPackage() == null) {
            return (Context)element.eContainer();
        }
        return this.findContext((DataContextElement)element.getPackage());
    }

    public Object[] getElements() {
        return this.elements.toArray(new DataContextElement[this.elements.size()]);
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }
}

