/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEditor
extends ProjectEditor
implements IManifestEditor {
    private static final String CRNL = "\r\n";
    private static final String CRNLSP = "\r\n ";
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String ASSIGN = "=";
    private static final String BUNDLE_SYMBOLIC_NAME = "bundle-symbolicName";
    private static final String SINGLETON = "singleton:=";
    private IFile manifestFile;
    private Manifest manifest;

    public ManifestEditor(IProject project) throws IOException, CoreException {
        super(project);
    }

    public boolean initOk() {
        return this.manifest != null && this.manifestFile != null;
    }

    @Override
    public void addDependency(String dependency) {
        this.addDependency(dependency, null);
    }

    @Override
    public void init() {
        super.init();
        if (this.manifest != null && this.manifestFile != null) {
            return;
        }
        if (this.manifestFile == null) {
            this.manifestFile = this.getManifestFile();
        }
        if (this.manifestFile != null) {
            try {
                this.manifest = new Manifest(this.manifestFile.getContents());
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
                throw new RuntimeException(e);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addDependency(String dependency, String version) {
        Attributes.Name rqBundle = new Attributes.Name("Require-Bundle");
        String requireBundle = this.manifest.getMainAttributes().getValue(rqBundle);
        if (requireBundle == null) {
            requireBundle = dependency;
            if (version != null) {
                requireBundle = String.valueOf(requireBundle) + SEMICOLON + version;
            }
        } else if (!requireBundle.contains(dependency)) {
            requireBundle = String.valueOf(requireBundle) + COMMA + dependency;
            if (version != null) {
                requireBundle = String.valueOf(requireBundle) + SEMICOLON + version;
            }
        }
        this.manifest.getMainAttributes().put(rqBundle, requireBundle);
    }

    @Override
    public boolean hasDependency(String dependency) {
        Attributes.Name rqBundle = new Attributes.Name("Require-Bundle");
        String requireBundle = this.manifest.getMainAttributes().getValue(rqBundle);
        return requireBundle != null && requireBundle.contains(dependency);
    }

    @Override
    public void setDependenciesVersion(String dependencyPattern, String newVersion) {
        Attributes.Name rqBundle = new Attributes.Name("Require-Bundle");
        String requireBundles = this.manifest.getMainAttributes().getValue(rqBundle);
        String[] bundles = requireBundles.split(COMMA);
        String newRequiredBundles = "";
        int ii = 0;
        while (ii < bundles.length) {
            String currentDependency = bundles[ii];
            String[] dependencyValue = currentDependency.split(SEMICOLON);
            if (dependencyValue[0].contains(dependencyPattern)) {
                String newBundleVersion = "bundle-version=\"" + newVersion + '\"';
                newRequiredBundles = String.valueOf(newRequiredBundles) + dependencyValue[0] + SEMICOLON + newBundleVersion;
                int i = 1;
                while (i < dependencyValue.length) {
                    String declaration = dependencyValue[i];
                    if (!declaration.contains("bundle-version=")) {
                        newRequiredBundles = String.valueOf(newRequiredBundles) + SEMICOLON + dependencyValue[i];
                    }
                    ++i;
                }
            } else {
                newRequiredBundles = String.valueOf(newRequiredBundles) + currentDependency;
            }
            if (ii < bundles.length - 1) {
                newRequiredBundles = String.valueOf(newRequiredBundles) + COMMA;
            }
            ++ii;
        }
        this.setValue("Require-Bundle", newRequiredBundles);
    }

    @Override
    public void setValue(String key, String value) {
        this.setValue(key, "", value);
    }

    @Override
    public void setValue(String key, String name, String value) {
        this.manifest.getMainAttributes().putValue(key, value);
    }

    @Override
    public void removeValue(String key, String value) {
    }

    @Override
    public void removeValue(String key) {
        this.manifest.getAttributes(key).remove(key);
    }

    private IFile getManifestFile() {
        IFile manifest = this.getProject().getFile("META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            return manifest;
        }
        return null;
    }

    @Override
    public boolean exists() {
        return super.exists() && this.getManifestFile() != null && this.getSymbolicBundleName() != null && this.getBundleVersion() != null;
    }

    @Override
    public void save() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.manifest.write(os);
            final StringReader reader = new StringReader(this.format(os.toString("UTF-8")));
            this.manifestFile.setContents(new InputStream(){

                public int read() throws IOException {
                    return reader.read();
                }
            }, true, true, null);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (CoreException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected String format(String text) {
        String[] lines = text.split(CRNLSP);
        String non72safe = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            non72safe = String.valueOf(non72safe) + line;
            ++n2;
        }
        lines = non72safe.split(COMMA);
        String newText = "";
        int i = 0;
        while (i < lines.length) {
            newText = String.valueOf(newText) + lines[i].trim();
            if (i < lines.length - 1) {
                newText = String.valueOf(newText) + ",\r\n ";
            }
            ++i;
        }
        return String.valueOf(newText) + CRNL;
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        IFile classpath = this.getProject().getFile("META-INF/MANIFEST.MF");
        if (!classpath.exists()) {
            files.add("META-INF/MANIFEST.MF");
        }
        return files;
    }

    @Override
    public void createFiles(Set<String> files) {
        if (files.contains("META-INF/MANIFEST.MF")) {
            this.manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
            if (!this.manifestFile.exists()) {
                try {
                    IContainer parent;
                    String input = "Manifest-Version: 1.0\n";
                    if (!this.manifestFile.getParent().exists() && (parent = this.manifestFile.getParent()) instanceof IFolder && !parent.exists()) {
                        ((IFolder)parent).create(true, false, null);
                    }
                    this.manifestFile.create(this.getInputStream("Manifest-Version: 1.0\n"), true, null);
                    this.manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
                    this.manifest = new Manifest(this.manifestFile.getContents());
                }
                catch (CoreException ex) {
                    Activator.log.error((Throwable)ex);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        if (this.getSymbolicBundleName() == null) {
            this.setSymbolicBundleName(this.getProject().getName());
        }
        if (this.getBundleVersion() == null) {
            this.setBundleVersion("0.0.1");
        }
    }

    @Override
    public void setSymbolicBundleName(String newName) {
        if (newName == null) {
            newName = "noName";
        }
        Attributes.Name symbolicName = new Attributes.Name(BUNDLE_SYMBOLIC_NAME);
        this.manifest.getMainAttributes().put(symbolicName, newName);
    }

    @Override
    public String getSymbolicBundleName() {
        if (this.manifest != null) {
            Attributes.Name symbolicName = new Attributes.Name(BUNDLE_SYMBOLIC_NAME);
            String name = this.manifest.getMainAttributes().getValue(symbolicName);
            int semiColon = name.indexOf(SEMICOLON);
            if (semiColon != -1) {
                return name.substring(0, semiColon);
            }
            return name;
        }
        return null;
    }

    @Override
    public String getBundleVersion() {
        if (this.manifest != null) {
            Attributes.Name symbolicName = new Attributes.Name("bundle-version");
            String version = this.manifest.getMainAttributes().getValue(symbolicName);
            return version;
        }
        return null;
    }

    @Override
    public void setBundleVersion(String version) {
        if (this.manifest != null) {
            Attributes.Name bundleVersion = new Attributes.Name("bundle-version");
            if (version == null) {
                this.manifest.getMainAttributes().remove(bundleVersion);
            } else {
                this.manifest.getMainAttributes().put(bundleVersion, version);
            }
        }
    }

    @Override
    public String getBundleVendor() {
        if (this.manifest != null) {
            Attributes.Name bundleVendor = new Attributes.Name("Bundle-Vendor");
            return this.manifest.getMainAttributes().getValue(bundleVendor);
        }
        return null;
    }

    @Override
    public void setBundleVendor(String vendor) {
        if (this.manifest != null) {
            Attributes.Name bundleVendor = new Attributes.Name("Bundle-Vendor");
            if (vendor == null) {
                this.manifest.getMainAttributes().remove(bundleVendor);
            } else {
                this.manifest.getMainAttributes().put(bundleVendor, vendor);
            }
        }
    }

    @Override
    public String getValue(String key) {
        if (this.manifest != null) {
            Attributes attributes;
            String value = this.manifest.getMainAttributes().getValue(key);
            if (value == null && (attributes = this.manifest.getAttributes(key)) != null) {
                value = attributes.getValue(key);
            }
            return value;
        }
        return null;
    }

    @Override
    public String getBundleName() {
        if (this.manifest != null) {
            Attributes.Name bundleName = new Attributes.Name("Bundle-Name");
            String name = this.manifest.getMainAttributes().getValue(bundleName);
            return name;
        }
        return null;
    }

    @Override
    public void setBundleName(String newName) {
        if (newName == null) {
            newName = "noName";
        }
        Attributes.Name bundleNameName = new Attributes.Name(BUNDLE_SYMBOLIC_NAME);
        this.manifest.getMainAttributes().put(bundleNameName, newName);
    }

    @Override
    public String getBundleLocalization() {
        if (this.manifest != null) {
            Attributes.Name bundleLocalization = new Attributes.Name("Bundle-Localization");
            String name = this.manifest.getMainAttributes().getValue(bundleLocalization);
            return name;
        }
        return null;
    }

    @Override
    public void setSingleton(boolean singleton) {
        String value = this.manifest.getMainAttributes().getValue(BUNDLE_SYMBOLIC_NAME);
        String[] directives = value.split(SEMICOLON);
        if (directives.length == 0) {
            return;
        }
        value = directives[0];
        boolean isDefined = false;
        int i = 1;
        while (i < directives.length) {
            String directive = directives[i];
            if (directive.startsWith(SINGLETON)) {
                directive = SINGLETON + singleton;
                isDefined = true;
            }
            value = String.valueOf(value) + SEMICOLON + directive;
            ++i;
        }
        if (!isDefined) {
            value = String.valueOf(value) + ";singleton:=" + singleton;
        }
        this.manifest.getMainAttributes().putValue(BUNDLE_SYMBOLIC_NAME, value);
    }
}

