/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.BuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.file.ClasspathEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IBuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IClasspathEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IJavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectEditor
extends ProjectEditor
implements IJavaProjectEditor {
    private final IJavaProject javaProject;
    private final IClasspathEditor classpathEditor;
    private final IBuildEditor buildEditor;

    @Override
    public IClasspathEditor getClasspathEditor() {
        return this.classpathEditor;
    }

    @Override
    public IBuildEditor getBuildEditor() {
        return this.buildEditor;
    }

    public JavaProjectEditor(IProject project) throws CoreException {
        super(project);
        this.javaProject = JavaCore.create((IProject)project);
        this.buildEditor = new BuildEditor(project);
        this.classpathEditor = new ClasspathEditor(this.javaProject);
    }

    @Override
    public boolean exists() {
        return super.exists() && this.javaProject.exists();
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        files.addAll(this.classpathEditor.getMissingFiles());
        files.addAll(this.buildEditor.getMissingFiles());
        return files;
    }

    @Override
    public Set<String> getMissingNature() {
        Set<String> natures = super.getMissingNature();
        if (!this.hasNature("org.eclipse.jdt.core.javanature")) {
            natures.add("org.eclipse.jdt.core.javanature");
        }
        return natures;
    }

    @Override
    public void init() {
        super.init();
        this.classpathEditor.init();
        this.buildEditor.init();
    }

    @Override
    public void createFiles(Set<String> files) {
        super.createFiles(files);
        this.classpathEditor.createFiles(files);
        this.buildEditor.createFiles(files);
    }

    @Override
    public void save() {
        super.save();
        try {
            this.javaProject.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (JavaModelException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.classpathEditor.save();
        this.buildEditor.save();
    }

    @Override
    public void addJavaSourceFolder(String path) {
        if (this.exists()) {
            String classPath = path;
            this.classpathEditor.addSourceFolderToClasspath(classPath);
            this.buildEditor.registerSourceFolder(String.valueOf(path) + "/");
        }
    }

    @Override
    public void registerSourceFolder(String string) {
        this.buildEditor.registerSourceFolder(string);
    }

    @Override
    public void addToBuild(String path) {
        this.buildEditor.addToBuild(path);
    }

    @Override
    public boolean isRegisteredSourceFolder(String path) {
        return this.buildEditor.isRegisteredSourceFolder(path);
    }

    @Override
    public String[] getSourceFolders() {
        return this.buildEditor.getSourceFolders();
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        Set<String> buildCommand = super.getMissingBuildCommand();
        if (!this.hasBuildCommand("org.eclipse.jdt.core.javabuilder")) {
            buildCommand.add("org.eclipse.jdt.core.javabuilder");
        }
        return buildCommand;
    }

    @Override
    public void removeFromBuild(String path) {
        this.buildEditor.removeFromBuild(path);
    }

    @Override
    public String[] getElementsInBuild() {
        return this.buildEditor.getElementsInBuild();
    }

    @Override
    public void registerBinFolder(String binFolder) {
        this.buildEditor.registerBinFolder(binFolder);
    }

    @Override
    public boolean isRegisteredBinFolder(String binFolder) {
        return this.buildEditor.isRegisteredBinFolder(binFolder);
    }
}

