/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.constraints.provider.CompositeConstraintItemProvider;
import org.eclipse.papyrus.infra.constraints.provider.ReferencePropertyItemProvider;
import org.eclipse.papyrus.infra.constraints.provider.SimpleConstraintItemProvider;
import org.eclipse.papyrus.infra.constraints.provider.ValuePropertyItemProvider;
import org.eclipse.papyrus.infra.constraints.util.ConstraintsAdapterFactory;

public class ConstraintsItemProviderAdapterFactory
extends ConstraintsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected SimpleConstraintItemProvider simpleConstraintItemProvider;
    protected CompositeConstraintItemProvider compositeConstraintItemProvider;
    protected ValuePropertyItemProvider valuePropertyItemProvider;
    protected ReferencePropertyItemProvider referencePropertyItemProvider;

    public ConstraintsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createSimpleConstraintAdapter() {
        if (this.simpleConstraintItemProvider == null) {
            this.simpleConstraintItemProvider = new SimpleConstraintItemProvider((AdapterFactory)this);
        }
        return this.simpleConstraintItemProvider;
    }

    public Adapter createCompositeConstraintAdapter() {
        if (this.compositeConstraintItemProvider == null) {
            this.compositeConstraintItemProvider = new CompositeConstraintItemProvider((AdapterFactory)this);
        }
        return this.compositeConstraintItemProvider;
    }

    public Adapter createValuePropertyAdapter() {
        if (this.valuePropertyItemProvider == null) {
            this.valuePropertyItemProvider = new ValuePropertyItemProvider((AdapterFactory)this);
        }
        return this.valuePropertyItemProvider;
    }

    public Adapter createReferencePropertyAdapter() {
        if (this.referencePropertyItemProvider == null) {
            this.referencePropertyItemProvider = new ReferencePropertyItemProvider((AdapterFactory)this);
        }
        return this.referencePropertyItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.simpleConstraintItemProvider != null) {
            this.simpleConstraintItemProvider.dispose();
        }
        if (this.compositeConstraintItemProvider != null) {
            this.compositeConstraintItemProvider.dispose();
        }
        if (this.valuePropertyItemProvider != null) {
            this.valuePropertyItemProvider.dispose();
        }
        if (this.referencePropertyItemProvider != null) {
            this.referencePropertyItemProvider.dispose();
        }
    }
}

