/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.celleditor.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;

public class SingleStringCellEditorConfiguration
implements ICellAxisConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.emf.nattable.celleditor.configuration.SingleStringCellEditorConfiguration.MultiLineText";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a multi-line text editor for a single String";
    }

    public boolean handles(Table table, Object axisElement) {
        EStructuralFeature feature;
        EClassifier etype;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        if (object instanceof EStructuralFeature && (etype = (feature = (EStructuralFeature)object).getEType()) instanceof EDataType) {
            EDataType datatype = (EDataType)etype;
            return "String".equals(datatype.getName());
        }
        return false;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new TextPainter(), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(), "EDIT", configLabel);
    }
}

