/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.EObjectAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;

public class EStructuralFeatureAxisManager
extends EObjectAxisManager {
    public boolean canBeSavedAsConfig() {
        return true;
    }

    @Override
    public boolean canDestroyAxisElement(Integer axisPosition) {
        return false;
    }

    public boolean canEditAxisHeader() {
        return true;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        ArrayList<EStructuralFeatureAxis> toAdd = new ArrayList<EStructuralFeatureAxis>();
        for (Object current : objectToAdd) {
            if (!this.isAllowedContents(current) || this.isAlreadyManaged(current)) continue;
            EStructuralFeatureAxis newAxis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
            newAxis.setElement((EStructuralFeature)current);
            newAxis.setManager(this.representedAxisManager);
            toAdd.add(newAxis);
            this.managedObject.add(current);
        }
        if (!toAdd.isEmpty()) {
            return AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd);
        }
        return null;
    }

    public Collection<Object> getAllPossibleAxis() {
        HashSet<Object> objects = new HashSet<Object>();
        for (Object current : this.getAllManagedAxis()) {
            EClass eClass = (EClass)current;
            EPackage ePackage = eClass.getEPackage();
            if (eClass.getEStructuralFeatures().isEmpty()) continue;
            objects.add(ePackage);
        }
        return objects;
    }

    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        HashSet<Object> features = new HashSet<Object>();
        for (Object current : objectToAdd) {
            if (!(current instanceof EObject)) continue;
            features.addAll((Collection<Object>)((EObject)current).eClass().getEAllStructuralFeatures());
        }
        features.removeAll(this.getElements());
        if (!features.isEmpty()) {
            return this.getAddAxisCommand(domain, features);
        }
        return null;
    }

    @Override
    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        if (axis instanceof EStructuralFeatureAxis) {
            return ((EStructuralFeatureAxis)axis).getElement().getName();
        }
        return null;
    }

    @Override
    public boolean isAllowedContents(Object object) {
        return object instanceof EStructuralFeature;
    }

    @Override
    public boolean isSlave() {
        return true;
    }
}

