/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.Activator;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadOnlyCache {
    private static final ThreadLocal<ReadOnlyCache> context = new ThreadLocal();
    private final ReadOnlyManager manager;
    private final Executor executor;
    private Map<Set<URI>, ReadOnlyState> resourceReadOnlyStates;
    private Map<EObject, ReadOnlyState> objectReadOnlyStates;
    private ConcurrentMap<AbstractReadOnlyHandler, ConcurrentMap<URI, ReadOnlyState>> handlerResourceReadOnlyCache;

    static {
        AbstractReadOnlyHandler.setResourceReadOnlyCacheProvider((AbstractReadOnlyHandler.ResourceReadOnlyCache.Provider)new ResourceReadOnlyCacheProvider());
    }

    ReadOnlyCache(ReadOnlyManager manager, Executor executor) {
        this.manager = manager;
        this.executor = executor;
    }

    static ReadOnlyCache create(ReadOnlyManager manager, Executor executor) {
        ReadOnlyCache result = new ReadOnlyCache(manager, executor);
        if (Platform.inDebugMode()) {
            Activator.log.info("Read-only cache activated for manager: " + manager);
        }
        return result;
    }

    public void dispose() {
        this.clear();
        if (Platform.inDebugMode()) {
            Activator.log.info("Read-only cache deactivated for manager: " + this.manager);
        }
    }

    public Optional<Boolean> getResources(Set<ReadOnlyAxis> axes, Set<URI> uris) {
        Map<Set<URI>, ReadOnlyState> resourceReadOnlyStates = this.getResourceReadOnlyStates();
        ReadOnlyState state = resourceReadOnlyStates == null ? null : resourceReadOnlyStates.get(uris);
        return state == null ? null : (Optional)state.get(axes);
    }

    public Optional<Boolean> getObject(Set<ReadOnlyAxis> axes, EObject object) {
        Map<EObject, ReadOnlyState> objectReadOnlyStates = this.getObjectReadOnlyStates();
        ReadOnlyState state = objectReadOnlyStates == null ? null : objectReadOnlyStates.get(object);
        return state == null ? null : (Optional)state.get(axes);
    }

    public void putResources(Set<ReadOnlyAxis> axes, Set<URI> uris, Optional<Boolean> readonly) {
        Map<Set<URI>, ReadOnlyState> resourceReadOnlyStates = this.getResourceReadOnlyStates();
        if (resourceReadOnlyStates != null) {
            ReadOnlyState state = resourceReadOnlyStates.get(uris);
            if (state == null) {
                state = new ReadOnlyState();
                resourceReadOnlyStates.put(uris, state);
            }
            state.put(axes, readonly);
        }
    }

    public void putObject(Set<ReadOnlyAxis> axes, EObject object, Optional<Boolean> readonly) {
        Map<EObject, ReadOnlyState> objectReadOnlyStates = this.getObjectReadOnlyStates();
        if (objectReadOnlyStates != null) {
            ReadOnlyState state = objectReadOnlyStates.get(object);
            if (state == null) {
                state = new ReadOnlyState();
                objectReadOnlyStates.put(object, state);
            }
            state.put(axes, readonly);
        }
    }

    public synchronized void clear() {
        this.resourceReadOnlyStates = null;
        this.objectReadOnlyStates = null;
        this.handlerResourceReadOnlyCache = null;
    }

    private Map<Set<URI>, ReadOnlyState> getResourceReadOnlyStates() {
        if (this.resourceReadOnlyStates == null) {
            this.initCache();
        }
        return this.resourceReadOnlyStates;
    }

    private Map<EObject, ReadOnlyState> getObjectReadOnlyStates() {
        if (this.objectReadOnlyStates == null) {
            this.initCache();
        }
        return this.objectReadOnlyStates;
    }

    private ConcurrentMap<AbstractReadOnlyHandler, ConcurrentMap<URI, ReadOnlyState>> getHandlerResourceReadOnlyCache() {
        if (this.handlerResourceReadOnlyCache == null) {
            this.initCache();
        }
        return this.handlerResourceReadOnlyCache;
    }

    private synchronized void initCache() {
        if (this.resourceReadOnlyStates == null) {
            this.resourceReadOnlyStates = Maps.newHashMap();
        }
        if (this.objectReadOnlyStates == null) {
            this.objectReadOnlyStates = Maps.newHashMap();
        }
        if (this.handlerResourceReadOnlyCache == null) {
            this.handlerResourceReadOnlyCache = Maps.newConcurrentMap();
        }
        this.executor.execute(new Runnable(){

            public void run() {
                ReadOnlyCache.this.clear();
            }
        });
    }

    void run(Runnable operation) {
        ReadOnlyCache previous = context.get();
        context.set(this);
        try {
            operation.run();
        }
        finally {
            if (previous == null) {
                context.remove();
            } else {
                context.set(previous);
            }
        }
    }

    AbstractReadOnlyHandler.ResourceReadOnlyCache getResourceReadOnlyCache(final AbstractReadOnlyHandler handler) {
        return new AbstractReadOnlyHandler.ResourceReadOnlyCache(){

            public Optional<Boolean> get(Set<ReadOnlyAxis> axes, URI resourceURI) {
                ReadOnlyState state;
                Map forHandler;
                ConcurrentMap handlerResourceReadOnlyCache = ReadOnlyCache.this.getHandlerResourceReadOnlyCache();
                Optional result = handlerResourceReadOnlyCache == null ? null : ((forHandler = (Map)handlerResourceReadOnlyCache.get(handler)) == null ? null : ((state = (ReadOnlyState)forHandler.get(resourceURI)) == null ? null : (Optional)state.get(axes)));
                return result;
            }

            public void put(Set<ReadOnlyAxis> axes, URI resourceURI, Optional<Boolean> readOnlyState) {
                ConcurrentMap handlerResourceReadOnlyCache = ReadOnlyCache.this.getHandlerResourceReadOnlyCache();
                if (handlerResourceReadOnlyCache != null) {
                    ReadOnlyState state;
                    ConcurrentMap forHandler = (ConcurrentMap)handlerResourceReadOnlyCache.get(handler);
                    if (forHandler == null) {
                        handlerResourceReadOnlyCache.putIfAbsent(handler, Maps.newConcurrentMap());
                        forHandler = (ConcurrentMap)handlerResourceReadOnlyCache.get(handler);
                    }
                    if ((state = (ReadOnlyState)forHandler.get(resourceURI)) == null) {
                        forHandler.putIfAbsent(resourceURI, new ReadOnlyState());
                        state = (ReadOnlyState)forHandler.get(resourceURI);
                    }
                    state.put(axes, readOnlyState);
                }
            }

            public void clear() {
                ReadOnlyCache.this.clear();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadOnlyState
    extends HashMap<Set<ReadOnlyAxis>, Optional<Boolean>> {
        private static final long serialVersionUID = 1L;

        private ReadOnlyState() {
        }
    }

    private static class ResourceReadOnlyCacheProvider
    implements AbstractReadOnlyHandler.ResourceReadOnlyCache.Provider {
        private ResourceReadOnlyCacheProvider() {
        }

        public AbstractReadOnlyHandler.ResourceReadOnlyCache get(AbstractReadOnlyHandler handler) {
            AbstractReadOnlyHandler.ResourceReadOnlyCache result = null;
            ReadOnlyCache cache = (ReadOnlyCache)context.get();
            if (cache != null) {
                result = cache.getResourceReadOnlyCache(handler);
            }
            return result;
        }
    }
}

