/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.requests.UnsetRequest;

public class UnsetValueCommand
extends EditElementCommand {
    private final EStructuralFeature feature;

    public UnsetValueCommand(UnsetRequest request) {
        super(request.getLabel(), request.getElementToEdit(), (IEditCommandRequest)request);
        this.feature = request.getFeature();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject elementToEdit = this.getElementToEdit();
        if (elementToEdit == null) {
            throw new ExecutionException("No element to edit");
        }
        elementToEdit.eUnset(this.feature);
        return CommandResult.newOKCommandResult();
    }

    public boolean canExecute() {
        EObject elementToEdit = this.getElementToEdit();
        return elementToEdit != null && super.canExecute();
    }
}

