/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFEnumeratorContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.IStrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public class EMFContentProvider
extends EncapsulatedContentProvider {
    public EMFContentProvider(EObject editedEObject, EStructuralFeature feature) {
        IStructuredContentProvider provider = this.getSemanticProvider(editedEObject, feature);
        this.encapsulated = this.encapsulateProvider(provider, editedEObject, feature);
    }

    protected IStructuredContentProvider getSemanticProvider(EObject editedEObject, EStructuralFeature feature) {
        EClassifier type = feature.getEType();
        if (type instanceof EEnum) {
            return new EMFEnumeratorContentProvider(feature);
        }
        if (type instanceof EClass) {
            return new SemanticEMFContentProvider(editedEObject, feature);
        }
        return EmptyContentProvider.instance;
    }

    protected EMFGraphicalContentProvider encapsulateProvider(IStructuredContentProvider provider, EObject editedEObject, EStructuralFeature feature) {
        String historyId = HistoryUtil.getHistoryID(editedEObject, feature);
        Object contentProvider = provider instanceof ITreeContentProvider ? this.getStrategyProvider((ITreeContentProvider)provider) : provider;
        ResourceSet rs = editedEObject == null ? null : (editedEObject.eResource() == null ? null : editedEObject.eResource().getResourceSet());
        EMFGraphicalContentProvider graphicalProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)contentProvider, rs, historyId);
        return graphicalProvider;
    }

    protected IStrategyBasedContentProvider getStrategyProvider(ITreeContentProvider provider) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        ContainmentBrowseStrategy revealStrategy = new ContainmentBrowseStrategy(provider);
        return new StrategyBasedContentProvider((TreeBrowseStrategy)browseStrategy, (TreeBrowseStrategy)revealStrategy);
    }
}

