/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AbstractServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ServiceUtilsForHandlers
extends AbstractServiceUtils<ExecutionEvent> {
    private static final ServiceUtilsForHandlers instance = new ServiceUtilsForHandlers();

    private ServiceUtilsForHandlers() {
    }

    public ServicesRegistry getServiceRegistry(ExecutionEvent from) throws ServiceException {
        Object context = from.getApplicationContext();
        if (context instanceof IEvaluationContext) {
            IWorkbenchPart part;
            Object selection;
            Object registry;
            IEvaluationContext evaluationContext = (IEvaluationContext)context;
            Object workbenchPartSite = evaluationContext.getVariable("org.eclipse.ui.IWorkbenchPartSite");
            if (workbenchPartSite instanceof IWorkbenchPartSite) {
                IWorkbenchPartSite site = (IWorkbenchPartSite)workbenchPartSite;
                registry = site.getAdapter(ServicesRegistry.class);
                if (registry != null && registry instanceof ServicesRegistry) {
                    return (ServicesRegistry)registry;
                }
                IWorkbenchPart workbenchPart = site.getPart();
                registry = workbenchPart.getAdapter(ServicesRegistry.class);
                if (registry != null && registry instanceof ServicesRegistry) {
                    return (ServicesRegistry)registry;
                }
            }
            if ((selection = evaluationContext.getVariable("selection")) instanceof ISelection && !((ISelection)selection).isEmpty()) {
                try {
                    registry = ServiceUtilsForSelection.getInstance().getServiceRegistry((ISelection)selection);
                    if (registry != null) {
                        return registry;
                    }
                }
                catch (ServiceException workbenchPart) {
                    // empty catch block
                }
            }
            if ((registry = (ServicesRegistry)(part = (IWorkbenchPart)evaluationContext.getVariable("activePart")).getAdapter(ServicesRegistry.class)) != null) {
                return registry;
            }
        }
        throw new ServiceNotFoundException("The ServiceRegistry cannot be resolved");
    }

    public static ServiceUtilsForHandlers getInstance() {
        return instance;
    }
}

