/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AbstractServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ServiceUtilsForIEvaluationContext
extends AbstractServiceUtils<IEvaluationContext> {
    private static final ServiceUtilsForIEvaluationContext instance = new ServiceUtilsForIEvaluationContext();

    private ServiceUtilsForIEvaluationContext() {
    }

    public ServicesRegistry getServiceRegistry(IEvaluationContext from) throws ServiceException {
        IWorkbenchPart part;
        Object _part;
        Object selection;
        Object registry;
        IEvaluationContext evaluationContext = from;
        Object workbenchPartSite = evaluationContext.getVariable("org.eclipse.ui.IWorkbenchPartSite");
        if (workbenchPartSite instanceof IWorkbenchPartSite) {
            IWorkbenchPartSite site = (IWorkbenchPartSite)workbenchPartSite;
            registry = site.getAdapter(ServicesRegistry.class);
            if (registry != null && registry instanceof ServicesRegistry) {
                return (ServicesRegistry)registry;
            }
            IWorkbenchPart workbenchPart = site.getPart();
            registry = workbenchPart.getAdapter(ServicesRegistry.class);
            if (registry != null && registry instanceof ServicesRegistry) {
                return (ServicesRegistry)registry;
            }
        }
        if ((selection = evaluationContext.getVariable("selection")) instanceof ISelection && !((ISelection)selection).isEmpty()) {
            try {
                registry = ServiceUtilsForSelection.getInstance().getServiceRegistry((ISelection)selection);
                if (registry != null) {
                    return registry;
                }
            }
            catch (ServiceException workbenchPart) {
                // empty catch block
            }
        }
        if ((_part = evaluationContext.getVariable("activePart")) instanceof IWorkbenchPart && (registry = (ServicesRegistry)(part = (IWorkbenchPart)_part).getAdapter(ServicesRegistry.class)) != null) {
            return registry;
        }
        throw new ServiceNotFoundException("The ServiceRegistry cannot be resolved");
    }

    public static ServiceUtilsForIEvaluationContext getInstance() {
        return instance;
    }
}

