/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.commands.NotifyingWorkspaceCommandStack;

public class NestingNotifyingWorkspaceCommandStack
extends NotifyingWorkspaceCommandStack {
    private NestingNotifyingWorkspaceCommandStack childCommandStack;
    private final boolean nested;
    private boolean executing;
    protected IUndoContext defaultUndoContext;

    public NestingNotifyingWorkspaceCommandStack(IOperationHistory history) {
        this(false, history, null);
    }

    protected NestingNotifyingWorkspaceCommandStack(boolean nested, IOperationHistory history, IUndoContext defaultUndoContext) {
        super(history);
        this.nested = nested;
        this.defaultUndoContext = defaultUndoContext;
    }

    protected NestingNotifyingWorkspaceCommandStack(boolean nested, IOperationHistory history) {
        this(nested, history, NestingNotifyingWorkspaceCommandStack.computeNestedUndoContext());
    }

    private static IUndoContext computeNestedUndoContext() {
        return new IUndoContext(){

            public boolean matches(IUndoContext context) {
                return context == this;
            }

            public String getLabel() {
                return "Nested Undo Context";
            }
        };
    }

    public IUndoContext getDefaultUndoContext() {
        if (this.defaultUndoContext == null) {
            return super.getDefaultUndoContext();
        }
        return this.defaultUndoContext;
    }

    protected NestingNotifyingWorkspaceCommandStack getTopMostCommandStack() {
        if (this.childCommandStack == null) {
            return this;
        }
        return this.childCommandStack.getTopMostCommandStack();
    }

    protected void startNestedTransaction(Command command) {
        if (this.childCommandStack != null) {
            this.childCommandStack.startNestedTransaction(command);
        } else {
            this.childCommandStack = this.createNestedCommandStack(this.getOperationHistory());
            this.childCommandStack.setEditingDomain(this.getDomain());
            this.childCommandStack.execute(command);
        }
    }

    protected NestingNotifyingWorkspaceCommandStack createNestedCommandStack(IOperationHistory history) {
        return new NestingNotifyingWorkspaceCommandStack(true, history);
    }

    public void commit() {
        if (this.childCommandStack != null) {
            this.disposeLastCommandStack();
        }
    }

    private boolean disposeLastCommandStack() {
        if (this.childCommandStack == null) {
            this.dispose();
            return true;
        }
        if (this.childCommandStack.disposeLastCommandStack()) {
            this.childCommandStack = null;
        }
        return false;
    }

    public void rollback() {
        if (this.childCommandStack != null) {
            while (this.canUndo()) {
                this.undo();
            }
            this.disposeLastCommandStack();
        }
    }

    public void execute(Command command) {
        if (this.childCommandStack == null) {
            if (!this.executing) {
                this.executing = true;
                try {
                    super.execute(command);
                }
                finally {
                    this.executing = false;
                }
            } else {
                try {
                    this.startNestedTransaction(command);
                    this.commit();
                }
                catch (OperationCanceledException e) {
                    this.rollback();
                    throw e;
                }
            }
        } else {
            this.childCommandStack.execute(command);
        }
    }

    protected void handleError(Exception exception) {
        RollbackException rbe;
        if (this.nested && exception instanceof RollbackException && (rbe = (RollbackException)exception).getStatus().getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (exception instanceof OperationCanceledException) {
            this.rollback();
        } else {
            super.handleError(exception);
        }
    }

    public Command getMostRecentCommand() {
        if (this.childCommandStack == null) {
            return super.getMostRecentCommand();
        }
        return this.childCommandStack.getMostRecentCommand();
    }

    public Command getRedoCommand() {
        if (this.childCommandStack == null) {
            return super.getRedoCommand();
        }
        return this.childCommandStack.getRedoCommand();
    }

    public Command getUndoCommand() {
        if (this.childCommandStack == null) {
            return super.getUndoCommand();
        }
        return this.childCommandStack.getUndoCommand();
    }

    public void undo() {
        if (this.childCommandStack == null) {
            super.undo();
        } else {
            this.childCommandStack.undo();
        }
    }

    public boolean canUndo() {
        if (this.childCommandStack == null) {
            return super.canUndo();
        }
        return this.childCommandStack.canUndo();
    }

    public boolean canRedo() {
        if (this.childCommandStack == null) {
            return super.canRedo();
        }
        return this.childCommandStack.canRedo();
    }

    public void redo() {
        if (this.childCommandStack == null) {
            super.redo();
        } else {
            this.childCommandStack.redo();
        }
    }
}

