/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.lang.reflect.Constructor;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.IGraphicalEditorSupport;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class GmfEditorFactory
extends AbstractEditorFactory {
    protected GmfEditorFactory(Class<?> diagramClass, String expectedType) {
        super(diagramClass, expectedType);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        Diagram diagram;
        if (pageIdentifier instanceof Diagram && !(diagram = (Diagram)pageIdentifier).eIsProxy()) {
            String type = diagram.getType();
            return this.getExpectedType().equals(type);
        }
        return false;
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new GMFEditorModel((Diagram)pageIdentifier, this.getServiceRegistry());
    }

    class GMFEditorModel
    implements IEditorModel {
        private Diagram diagram;
        private ServicesRegistry servicesRegistry;
        private Image tabIcon;

        public GMFEditorModel(Diagram pageIdentifier, ServicesRegistry servicesRegistry) {
            this.diagram = pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                Constructor c = GmfEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, Diagram.class);
                GraphicalEditor editor = (GraphicalEditor)c.newInstance(this.servicesRegistry, this.diagram);
                IGraphicalEditorSupport editorSupport = (IGraphicalEditorSupport)this.servicesRegistry.getService(IGraphicalEditorSupport.class);
                editorSupport.initialize(editor);
                return editor;
            }
            catch (Exception e) {
                throw new PartInitException(String.valueOf(Messages.GmfEditorFactory_ErrorCreatingEditorPart) + this.diagram, (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = GmfEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getRawModel() {
            return this.diagram;
        }

        public Image getTabIcon() {
            ImageDescriptor imageDescriptor;
            if (this.tabIcon == null && (imageDescriptor = DiagramUtils.getPrototype(this.diagram).getIconDescriptor()) != null) {
                this.tabIcon = imageDescriptor.createImage();
            }
            return this.tabIcon;
        }

        public String getTabTitle() {
            try {
                LabelProviderService service = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.diagram);
                return service.getLabelProvider().getText((Object)this.diagram);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return this.diagram.getName();
            }
        }

        public void dispose() {
            if (this.tabIcon != null) {
                this.tabIcon.dispose();
                this.tabIcon = null;
            }
        }
    }
}

